/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.cloud;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.JobIntentService;
import android.text.TextUtils;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingJob;
import org.infobip.mobile.messaging.cloud.MobileMessageHandler;
import org.infobip.mobile.messaging.cloud.RegistrationTokenHandler;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.platform.Lazy;
import org.infobip.mobile.messaging.platform.Platform;

public class MobileMessagingCloudService
extends JobIntentService {
    private static final String PREFIX = "org.infobip.mobile.messaging.cloud.";
    private static final String ACTION_CLOUD_MESSAGE_RECEIVE = "org.infobip.mobile.messaging.cloud.MESSAGE_RECEIVE";
    private static final String ACTION_TOKEN_ACQUIRE = "org.infobip.mobile.messaging.cloud.TOKEN_ACQUIRE";
    private static final String ACTION_TOKEN_CLEANUP = "org.infobip.mobile.messaging.cloud.TOKEN_CLEANUP";
    private static final String ACTION_TOKEN_RESET = "org.infobip.mobile.messaging.cloud.TOKEN_RESET";
    private static final String ACTION_NEW_TOKEN = "org.infobip.mobile.messaging.cloud.NEW_TOKEN";
    private static final String EXTRA_SENDER_ID = "org.infobip.mobile.messaging.cloud.SENDER_ID";
    private static final String EXTRA_TOKEN = "org.infobip.mobile.messaging.cloud.TOKEN";
    private final Lazy<RegistrationTokenHandler, Context> registrationTokenHandler;
    private final Lazy<MobileMessageHandler, Context> mobileMessageHandler;

    public MobileMessagingCloudService() {
        this.registrationTokenHandler = Platform.registrationTokenHandler;
        this.mobileMessageHandler = Platform.mobileMessageHandler;
    }

    @VisibleForTesting
    public MobileMessagingCloudService(RegistrationTokenHandler registrationTokenHandler, MobileMessageHandler mobileMessageHandler) {
        this.registrationTokenHandler = Lazy.just(registrationTokenHandler);
        this.mobileMessageHandler = Lazy.just(mobileMessageHandler);
    }

    public static void enqueueTokenAcquisition(Context context, String senderId) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot acquire token, senderId is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent(ACTION_TOKEN_ACQUIRE).putExtra(EXTRA_SENDER_ID, senderId));
    }

    public static void enqueueTokenCleanup(Context context, String senderId) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot cleanup token, senderId is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent(ACTION_TOKEN_CLEANUP).putExtra(EXTRA_SENDER_ID, senderId));
    }

    public static void enqueueTokenReset(Context context, String senderId) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot reset token, senderId is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent(ACTION_TOKEN_RESET).putExtra(EXTRA_SENDER_ID, senderId));
    }

    public static void enqueueNewToken(Context context, String senderId, String token) {
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot process new token, senderId is empty");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)senderId)) {
            MobileMessagingLogger.e("Cannot process new token, token is empty");
            return;
        }
        MobileMessagingCloudService.enqueueWork(context, new Intent(ACTION_NEW_TOKEN).putExtra(EXTRA_SENDER_ID, senderId).putExtra(EXTRA_TOKEN, token));
    }

    public static void enqueueNewMessage(Context context, Message message) {
        Bundle messageBundle = MessageBundleMapper.messageToBundle(message);
        MobileMessagingCloudService.enqueueWork(context, new Intent(ACTION_CLOUD_MESSAGE_RECEIVE).putExtras(messageBundle));
    }

    private static void enqueueWork(Context context, Intent work) {
        MobileMessagingCloudService.enqueueWork((Context)context, MobileMessagingCloudService.class, (int)MobileMessagingJob.getScheduleId(context, 2), (Intent)work.setPackage(context.getPackageName()));
    }

    protected void onHandleWork(@NonNull Intent intent) {
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "org.infobip.mobile.messaging.cloud.MESSAGE_RECEIVE": {
                this.handleMessage(intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.NEW_TOKEN": {
                this.handleNewToken(intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.TOKEN_CLEANUP": {
                this.handleTokenCleanup(intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.TOKEN_RESET": {
                this.handleTokenReset(intent);
                break;
            }
            case "org.infobip.mobile.messaging.cloud.TOKEN_ACQUIRE": {
                this.handleTokenAcquire(intent);
            }
        }
    }

    private void handleNewToken(@NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        String token = intent.getStringExtra(EXTRA_TOKEN);
        this.registrationTokenHandler.get((Context)this).handleNewToken(senderId, token);
    }

    private void handleTokenAcquire(@NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        this.registrationTokenHandler.get((Context)this).acquireNewToken(senderId);
    }

    private void handleTokenCleanup(@NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        this.registrationTokenHandler.get((Context)this).cleanupToken(senderId);
    }

    private void handleTokenReset(@NonNull Intent intent) {
        String senderId = intent.getStringExtra(EXTRA_SENDER_ID);
        RegistrationTokenHandler handler = this.registrationTokenHandler.get((Context)this);
        handler.cleanupToken(senderId);
        handler.acquireNewToken(senderId);
    }

    private void handleMessage(@NonNull Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            MobileMessagingLogger.e("No extras in intent, cannot receive message");
            return;
        }
        Message message = MessageBundleMapper.messageFromBundle(extras);
        this.mobileMessageHandler.get((Context)this).handleMessage(message);
    }
}

