/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.dal.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.dal.sqlite.BaseDatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.SharedPreferencesMigrator;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class PushDatabaseHelperImpl
extends BaseDatabaseHelper {
    static final int VER_2017_JAN_12 = 1;
    static final int VER_2017_FEB_14 = 2;
    static final int VER_2017_MAY_15 = 3;
    static final int VER_2017_AUG_25 = 4;
    static final int VER_2019_JAN_21 = 5;
    private static final int VER_CURRENT = 5;
    static final String DATABASE_NAME = "mm_infobip_database.db";
    private static final String SQL_CREATE_MESSAGES_TABLE = "CREATE TABLE messages (id TEXT PRIMARY KEY NOT NULL ON CONFLICT FAIL, title TEXT, body TEXT, sound TEXT, vibrate INTEGER NOT NULL DEFAULT 1, icon TEXT, silent INTEGER NOT NULL DEFAULT 0, category TEXT, _from TEXT, received_timestamp INTEGER, seen_timestamp INTEGER, internal_data TEXT, custom_payload TEXT, destination TEXT, status TEXT,status_message TEXT)";
    private static final String SQL_CREATE_GEO_MESSAGES_TABLE = "CREATE TABLE geo_messages (id TEXT PRIMARY KEY NOT NULL ON CONFLICT FAIL, title TEXT, body TEXT, sound TEXT, vibrate INTEGER NOT NULL DEFAULT 1, icon TEXT, silent INTEGER NOT NULL DEFAULT 0, category TEXT, _from TEXT, received_timestamp INTEGER, seen_timestamp INTEGER, internal_data TEXT, custom_payload TEXT, destination TEXT, status TEXT,status_message TEXT)";
    private static final String SQL_ALTER_TABLE_MESSAGES_WITH_CONTENT_URL = "ALTER TABLE messages ADD COLUMN content_url TEXT;";
    private static final String SQL_ALTER_TABLE_GEO_MESSAGES_WITH_CONTENT_URL = "ALTER TABLE geo_messages ADD COLUMN content_url TEXT;";
    private static final String SQL_ALTER_TABLE_MESSAGES_WITH_IN_APP_STYLE = "ALTER TABLE messages ADD COLUMN in_app_style TEXT;";
    private static final String SQL_ALTER_TABLE_GEO_MESSAGES_WITH_IN_APP_STYLE = "ALTER TABLE geo_messages ADD COLUMN in_app_style TEXT;";

    public PushDatabaseHelperImpl(Context context) {
        super(context, DATABASE_NAME, 5);
    }

    public void onCreate(SQLiteDatabase db) {
        db.beginTransaction();
        db.execSQL(SQL_CREATE_MESSAGES_TABLE);
        db.execSQL(SQL_ALTER_TABLE_MESSAGES_WITH_CONTENT_URL);
        db.execSQL(SQL_CREATE_GEO_MESSAGES_TABLE);
        db.execSQL(SQL_ALTER_TABLE_GEO_MESSAGES_WITH_CONTENT_URL);
        db.execSQL(SQL_ALTER_TABLE_MESSAGES_WITH_IN_APP_STYLE);
        db.execSQL(SQL_ALTER_TABLE_GEO_MESSAGES_WITH_IN_APP_STYLE);
        db.setTransactionSuccessful();
        db.endTransaction();
        SharedPreferencesMigrator.migrateMessages(this.context, db);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        int version = oldVersion;
        if (version <= 1) {
            db.execSQL(SQL_CREATE_GEO_MESSAGES_TABLE);
            version = 2;
        }
        if (version <= 2) {
            db.execSQL(SQL_ALTER_TABLE_MESSAGES_WITH_CONTENT_URL);
            db.execSQL(SQL_ALTER_TABLE_GEO_MESSAGES_WITH_CONTENT_URL);
            version = 3;
        }
        if (version <= 3) {
            this.setSendDateTimeToReceivedTimeIfAbsent(db);
            version = 4;
        }
        if (version <= 4) {
            db.execSQL(SQL_ALTER_TABLE_MESSAGES_WITH_IN_APP_STYLE);
            db.execSQL(SQL_ALTER_TABLE_GEO_MESSAGES_WITH_IN_APP_STYLE);
            version = 5;
        }
        if (version != 5) {
            MobileMessagingLogger.e("SQLite DB version is not what expected: 5");
        }
    }

    private void setSendDateTimeToReceivedTimeIfAbsent(SQLiteDatabase db) {
        Cursor cursor = db.rawQuery("SELECT * FROM messages", new String[0]);
        class Message {
            private String id;
            private String title;
            private String body;
            private String sound;
            private int vibrate;
            private String icon;
            private short silent;
            private String category;
            private String from;
            private long receivedTimestamp;
            private long seenTimestamp;
            private String customPayload;
            private String internalData;
            private String contentUrl;
            private String destination;
            private String status;
            private String statusMessage;

            Message() {
            }
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        if (cursor.moveToFirst()) {
            do {
                try {
                    Message message = new Message();
                    message.id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                    message.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                    message.body = cursor.getString(cursor.getColumnIndexOrThrow("body"));
                    message.sound = cursor.getString(cursor.getColumnIndexOrThrow("sound"));
                    message.vibrate = cursor.getInt(cursor.getColumnIndexOrThrow("vibrate"));
                    message.icon = cursor.getString(cursor.getColumnIndexOrThrow("icon"));
                    message.silent = cursor.getShort(cursor.getColumnIndexOrThrow("silent"));
                    message.category = cursor.getString(cursor.getColumnIndexOrThrow("category"));
                    message.from = cursor.getString(cursor.getColumnIndexOrThrow("_from"));
                    message.receivedTimestamp = cursor.getLong(cursor.getColumnIndexOrThrow("received_timestamp"));
                    message.seenTimestamp = cursor.getLong(cursor.getColumnIndexOrThrow("seen_timestamp"));
                    message.customPayload = cursor.getString(cursor.getColumnIndexOrThrow("custom_payload"));
                    message.internalData = cursor.getString(cursor.getColumnIndexOrThrow("internal_data"));
                    message.contentUrl = cursor.getString(cursor.getColumnIndexOrThrow("content_url"));
                    message.destination = cursor.getString(cursor.getColumnIndexOrThrow("destination"));
                    message.status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    message.statusMessage = cursor.getString(cursor.getColumnIndexOrThrow("status_message"));
                    messages.add(message);
                }
                catch (Exception e) {
                    MobileMessagingLogger.e(Log.getStackTraceString((Throwable)e));
                }
            } while (cursor.moveToNext());
        }
        cursor.close();
        JsonSerializer serializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);
        for (Message m : messages) {
            HashMap<String, Long> internalDataMap = (HashMap<String, Long>)serializer.deserialize(m.internalData, HashMap.class);
            if (internalDataMap == null) {
                internalDataMap = new HashMap<String, Long>();
            }
            if (!internalDataMap.containsKey("sendDateTime")) {
                internalDataMap.put("sendDateTime", m.receivedTimestamp);
            }
            m.internalData = serializer.serialize(internalDataMap);
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", m.id);
            contentValues.put("title", m.title);
            contentValues.put("body", m.body);
            contentValues.put("sound", m.sound);
            contentValues.put("vibrate", Integer.valueOf(m.vibrate));
            contentValues.put("icon", m.icon);
            contentValues.put("silent", Short.valueOf(m.silent));
            contentValues.put("category", m.category);
            contentValues.put("_from", m.from);
            contentValues.put("received_timestamp", Long.valueOf(m.receivedTimestamp));
            contentValues.put("seen_timestamp", Long.valueOf(m.seenTimestamp));
            contentValues.put("custom_payload", m.customPayload);
            contentValues.put("internal_data", m.internalData);
            contentValues.put("content_url", m.contentUrl);
            contentValues.put("destination", m.destination);
            contentValues.put("status", m.status);
            contentValues.put("status_message", m.statusMessage);
            db.insertWithOnConflict("messages", null, contentValues, 5);
        }
    }
}

