/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.interactive;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.dal.json.InternalDataMapper;
import org.infobip.mobile.messaging.interactive.MobileInteractive;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.interactive.inapp.InAppNotificationHandler;
import org.infobip.mobile.messaging.interactive.inapp.InAppNotificationHandlerImpl;
import org.infobip.mobile.messaging.interactive.predefined.PredefinedActionsProvider;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileInteractiveImpl
extends MobileInteractive
implements MessageHandlerModule {
    private static MobileInteractiveImpl instance;
    private Context context;
    private final JsonSerializer serializer = new JsonSerializer(false, new JsonSerializer.ObjectAdapter[0]);
    private Set<NotificationCategory> customNotificationCategories;
    private Set<NotificationCategory> predefinedNotificationCategories;
    private MobileMessagingCore mobileMessagingCore;
    private InAppNotificationHandler inAppNotificationHandler;
    private PredefinedActionsProvider predefinedActionsProvider;

    public MobileInteractiveImpl() {
    }

    @VisibleForTesting
    MobileInteractiveImpl(Context context, MobileMessagingCore mobileMessagingCore, InAppNotificationHandler inAppNotificationHandler, PredefinedActionsProvider predefinedActionsProvider) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.inAppNotificationHandler = inAppNotificationHandler;
        this.predefinedActionsProvider = predefinedActionsProvider;
    }

    public static MobileInteractiveImpl getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        instance = (MobileInteractiveImpl)MobileMessagingCore.getInstance(context).getMessageHandlerModule(MobileInteractiveImpl.class);
        return instance;
    }

    @Override
    public void setNotificationCategories(NotificationCategory ... notificationCategories) {
        this.validateWithParam(notificationCategories);
        this.predefinedNotificationCategories = this.getPredefinedNotificationCategories();
        this.setCustomNotificationCategories(notificationCategories);
    }

    @Override
    public NotificationCategory getNotificationCategory(String categoryId) {
        if (StringUtils.isBlank(categoryId)) {
            return null;
        }
        this.predefinedActionsProvider(this.context).verifyResourcesForCategory(categoryId);
        Set<NotificationCategory> storedNotificationCategories = this.getNotificationCategories();
        if (storedNotificationCategories == MobileMessagingProperty.INTERACTIVE_CATEGORIES.getDefaultValue()) {
            return null;
        }
        for (NotificationCategory notificationCategory : storedNotificationCategories) {
            if (!categoryId.equals(notificationCategory.getCategoryId())) continue;
            return notificationCategory;
        }
        return null;
    }

    @Override
    @NonNull
    public Set<NotificationCategory> getNotificationCategories() {
        if (!this.isDisplayNotificationEnabled()) {
            return new HashSet<NotificationCategory>();
        }
        Set<NotificationCategory> notificationCategories = this.getPredefinedNotificationCategories();
        Set<NotificationCategory> customNotificationCategories = this.getCustomNotificationCategories();
        notificationCategories.addAll(customNotificationCategories);
        return notificationCategories;
    }

    @Override
    public void triggerSdkActionsFor(NotificationAction action, Message message) {
        this.markAsSeen(this.context, message.getMessageId());
        this.sendMo(this.context, message.getCategory(), action, message);
        this.inAppNotificationHandler(this.context).userPressedNotificationButtonForMessage(message);
    }

    private void markAsSeen(Context context, String messageId) {
        NotificationSettings notificationSettings = this.mobileMessagingCore(context).getNotificationSettings();
        if (notificationSettings == null) {
            return;
        }
        if (notificationSettings.markSeenOnTap()) {
            this.mobileMessagingCore(context).setMessagesSeen(messageId);
        }
    }

    private void sendMo(Context context, String categoryId, NotificationAction action, Message initialMessage) {
        if (!action.sendsMoMessage()) {
            return;
        }
        if (StringUtils.isBlank(categoryId)) {
            return;
        }
        this.mobileMessagingCore(context).sendMessagesWithRetry(this.messageFor(categoryId, action, initialMessage));
    }

    private Message messageFor(String categoryId, NotificationAction action, Message initialMessage) {
        Message message = new Message();
        message.setBody(categoryId + " " + action.getId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("initialMessageId", initialMessage.getMessageId());
        message.setInternalData(InternalDataMapper.mergeExistingInternalDataWithAnythingToJson(initialMessage.getInternalData(), map));
        return message;
    }

    private Set<NotificationCategory> getPredefinedNotificationCategories() {
        if (null != this.predefinedNotificationCategories) {
            return this.predefinedNotificationCategories;
        }
        return this.predefinedActionsProvider(this.context).getPredefinedCategories();
    }

    void setCustomNotificationCategories(NotificationCategory[] notificationCategories) {
        if (notificationCategories == null) {
            return;
        }
        this.customNotificationCategories = notificationCategories.length == 0 ? null : new HashSet<NotificationCategory>(Arrays.asList(notificationCategories));
        HashSet<String> customNotificationCategoriesStringSet = new HashSet<String>();
        for (NotificationCategory customNotificationCategory : notificationCategories) {
            customNotificationCategoriesStringSet.add(customNotificationCategory.toString());
        }
        PreferenceHelper.saveStringSet(this.context, MobileMessagingProperty.INTERACTIVE_CATEGORIES, customNotificationCategoriesStringSet);
    }

    @NonNull
    private Set<NotificationCategory> getCustomNotificationCategories() {
        if (null != this.customNotificationCategories) {
            return this.customNotificationCategories;
        }
        Set<String> notificationCategoriesStringSet = PreferenceHelper.findStringSet(this.context, MobileMessagingProperty.INTERACTIVE_CATEGORIES);
        HashSet<NotificationCategory> notificationCategoriesTemp = new HashSet<NotificationCategory>();
        if (notificationCategoriesStringSet != MobileMessagingProperty.INTERACTIVE_CATEGORIES.getDefaultValue()) {
            for (String category : notificationCategoriesStringSet) {
                NotificationCategory notificationCategory = (NotificationCategory)this.serializer.deserialize(category, NotificationCategory.class);
                notificationCategoriesTemp.add(notificationCategory);
            }
        }
        this.customNotificationCategories = notificationCategoriesTemp;
        return this.customNotificationCategories;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    private void validateWithParam(Object o) {
        if (null != o) {
            return;
        }
        throw new IllegalArgumentException("Can't use 'set' method with null argument!");
    }

    @Override
    public void init(Context appContext) {
        this.context = appContext;
    }

    @Override
    public boolean handleMessage(Message message) {
        this.inAppNotificationHandler(this.context).handleMessage(message);
        return false;
    }

    @Override
    public boolean messageTapped(Message message) {
        this.inAppNotificationHandler(this.context).userTappedNotificationForMessage(message);
        return false;
    }

    @Override
    public void applicationInForeground() {
        this.inAppNotificationHandler(this.context).appWentToForeground();
    }

    @Override
    public void cleanup() {
        PreferenceHelper.remove(this.context, MobileMessagingProperty.INTERACTIVE_CATEGORIES.getKey());
    }

    @Override
    public void logoutUser() {
    }

    private MobileMessagingCore mobileMessagingCore(Context context) {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance(context);
        }
        return this.mobileMessagingCore;
    }

    private InAppNotificationHandler inAppNotificationHandler(Context context) {
        if (this.inAppNotificationHandler == null) {
            this.inAppNotificationHandler = new InAppNotificationHandlerImpl(context);
        }
        return this.inAppNotificationHandler;
    }

    private PredefinedActionsProvider predefinedActionsProvider(Context context) {
        if (this.predefinedActionsProvider == null) {
            this.predefinedActionsProvider = new PredefinedActionsProvider(context);
        }
        return this.predefinedActionsProvider;
    }
}

