/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.common;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.api.support.ApiBackendExceptionWithContent;
import org.infobip.mobile.messaging.api.support.ApiIOException;
import org.infobip.mobile.messaging.api.support.http.client.DefaultApiClient;
import org.infobip.mobile.messaging.mobile.common.ResultWrapper;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendCommunicationException;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendCommunicationExceptionWithContent;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterException;
import org.infobip.mobile.messaging.mobile.common.exceptions.BackendInvalidParameterExceptionWithContent;

public abstract class MAsyncTask<IN, OUT> {
    private static final Set<String> invalidParameterErrorCodes = new HashSet<String>(){
        {
            this.add("5");
            this.add("9");
            this.add("17");
            this.add("18");
        }
    };
    @SuppressLint(value={"StaticFieldLeak"})
    private final AsyncTask<IN, Void, ResultWrapper<IN, OUT>> asyncTask = new AsyncTask<IN, Void, ResultWrapper<IN, OUT>>(){

        protected void onPreExecute() {
            MAsyncTask.this.before();
        }

        protected ResultWrapper<IN, OUT> doInBackground(IN[] ins) {
            try {
                return new ResultWrapper(MAsyncTask.this.run(ins));
            }
            catch (Throwable error) {
                return new ResultWrapper(ins, error);
            }
        }

        protected void onPostExecute(ResultWrapper<IN, OUT> resultWrapper) {
            if (resultWrapper.error == null) {
                MAsyncTask.this.after(resultWrapper.result);
                return;
            }
            Throwable error = MAsyncTask.backendErrorToTaskError(resultWrapper.error);
            MAsyncTask.this.error(error);
            MAsyncTask.this.error(resultWrapper.inputs, error);
        }
    };

    public void before() {
    }

    public abstract OUT run(IN[] var1);

    public void after(OUT out) {
    }

    public void error(Throwable error) {
    }

    public void error(IN[] ins, Throwable error) {
    }

    public void execute(IN ... ins) {
        this.asyncTask.execute((Object[])ins);
    }

    public void execute(Executor executor, IN ... ins) {
        this.asyncTask.executeOnExecutor(executor, (Object[])ins);
    }

    private static Throwable backendErrorToTaskError(Throwable originalError) {
        if (MAsyncTask.isInvalidParameterErrorWithContent(originalError)) {
            return new BackendInvalidParameterExceptionWithContent(originalError.getMessage(), (ApiBackendExceptionWithContent)originalError);
        }
        if (MAsyncTask.isErrorWithContent(originalError)) {
            return new BackendCommunicationExceptionWithContent(originalError.getMessage(), (ApiBackendExceptionWithContent)originalError);
        }
        if (MAsyncTask.isInvalidParameterError(originalError)) {
            return new BackendInvalidParameterException(originalError.getMessage(), (ApiIOException)originalError);
        }
        if (MAsyncTask.isBackendError(originalError)) {
            return new BackendCommunicationException(originalError.getMessage(), (ApiIOException)originalError);
        }
        return originalError;
    }

    private static boolean isBackendError(@NonNull Throwable error) {
        if (!(error instanceof ApiIOException)) {
            return false;
        }
        String errorCode = ((ApiIOException)error).getCode();
        return DefaultApiClient.ErrorCode.UNKNOWN_API_BACKEND_ERROR.getValue().equals(errorCode);
    }

    private static boolean isInvalidParameterError(@NonNull Throwable error) {
        if (!(error instanceof ApiIOException)) {
            return false;
        }
        String code = ((ApiIOException)error).getCode();
        return invalidParameterErrorCodes.contains(code);
    }

    private static boolean isErrorWithContent(@NonNull Throwable error) {
        return error instanceof ApiBackendExceptionWithContent;
    }

    private static boolean isInvalidParameterErrorWithContent(@NonNull Throwable error) {
        return error instanceof ApiBackendExceptionWithContent && MAsyncTask.isInvalidParameterError(error);
    }
}

