/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.instance;

import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.api.instance.Instance;
import org.infobip.mobile.messaging.api.instance.MobileApiInstance;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.instance.InstanceActionListener;

public class InstanceSynchronizer {
    private final Executor executor;
    private final MobileApiInstance mobileApiInstance;
    private final MRetryPolicy retryPolicy;

    public InstanceSynchronizer(Executor executor, MobileApiInstance mobileApiInstance, MRetryPolicy retryPolicy) {
        this.executor = executor;
        this.mobileApiInstance = mobileApiInstance;
        this.retryPolicy = retryPolicy;
    }

    public void fetch(final InstanceActionListener actionListener) {
        new MRetryableTask<Void, Boolean>(){

            public Boolean run(Void[] voids) {
                MobileMessagingLogger.v("GET PRIMARY >>>");
                Instance instance = InstanceSynchronizer.this.mobileApiInstance.get();
                MobileMessagingLogger.v("GET PRIMARY <<<", instance);
                return instance.getPrimary();
            }

            @Override
            public void error(Throwable error) {
                if (actionListener != null) {
                    actionListener.onError(error);
                }
                MobileMessagingLogger.v("GET PRIMARY ERROR <<<", error);
            }

            @Override
            public void after(Boolean primary) {
                if (actionListener != null) {
                    actionListener.onSuccess(primary);
                }
            }
        }.retryWith(this.retryPolicy).execute(this.executor, (IN[])new Void[0]);
    }

    public void sync(final Boolean primary, final InstanceActionListener actionListener) {
        new MRetryableTask<Boolean, Void>(){

            public Void run(Boolean[] params) {
                Instance instance = new Instance(params[0]);
                MobileMessagingLogger.v("UPDATE PRIMARY >>>", instance);
                InstanceSynchronizer.this.mobileApiInstance.update(instance);
                MobileMessagingLogger.v("UPDATE PRIMARY <<<");
                return null;
            }

            @Override
            public void after(Void aVoid) {
                if (actionListener != null) {
                    actionListener.onSuccess(primary);
                }
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.v("UPDATE PRIMARY ERROR <<<", error);
                if (actionListener != null) {
                    actionListener.onError(error);
                }
            }
        }.retryWith(this.retryPolicy).execute(this.executor, (IN[])new Boolean[]{primary});
    }
}

