/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.registration;

import android.content.Context;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.api.registration.MobileApiRegistration;
import org.infobip.mobile.messaging.api.registration.RegistrationResponse;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.common.MRetryableTask;
import org.infobip.mobile.messaging.mobile.common.RetryPolicyProvider;
import org.infobip.mobile.messaging.mobile.registration.Registration;
import org.infobip.mobile.messaging.platform.Broadcaster;
import org.infobip.mobile.messaging.platform.Platform;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.stats.MobileMessagingStatsError;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class RegistrationSynchronizer {
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;
    private final MobileMessagingStats stats;
    private final Executor executor;
    private final Broadcaster broadcaster;
    private final RetryPolicyProvider retryPolicyProvider;
    private final MobileApiRegistration mobileApiRegistration;

    public RegistrationSynchronizer(Context context, MobileMessagingCore mobileMessagingCore, MobileMessagingStats stats, Executor executor, Broadcaster broadcaster, RetryPolicyProvider retryPolicyProvider, MobileApiRegistration mobileApiRegistration) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.stats = stats;
        this.executor = executor;
        this.broadcaster = broadcaster;
        this.retryPolicyProvider = retryPolicyProvider;
        this.mobileApiRegistration = mobileApiRegistration;
    }

    public void updateStatus(Boolean enabled) {
        new MRetryableTask<Boolean, Registration>(){

            public Registration run(Boolean[] params) {
                String cloudToken = RegistrationSynchronizer.this.mobileMessagingCore.getCloudToken();
                Boolean pushRegistrationEnabled = params.length > 0 ? params[0] : null;
                MobileMessagingLogger.v("REGISTRATION >>>", (Object)cloudToken, pushRegistrationEnabled);
                RegistrationResponse registrationResponse = RegistrationSynchronizer.this.mobileApiRegistration.upsert(cloudToken, pushRegistrationEnabled, Platform.usedPushServiceType);
                MobileMessagingLogger.v("REGISTRATION <<<", registrationResponse);
                return new Registration(cloudToken, registrationResponse.getDeviceApplicationInstanceId(), registrationResponse.getPushRegistrationEnabled());
            }

            @Override
            public void after(Registration registration) {
                RegistrationSynchronizer.this.setPushRegistrationEnabled(registration.enabled);
                RegistrationSynchronizer.this.setPushRegistrationId(registration.registrationId);
                RegistrationSynchronizer.this.setRegistrationIdReported(true);
                RegistrationSynchronizer.this.mobileMessagingCore.setReportedPushServiceType();
                RegistrationSynchronizer.this.broadcaster.registrationEnabled(registration.cloudToken, registration.registrationId, registration.enabled);
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.e("MobileMessaging API returned error (push registration status update)!");
                RegistrationSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                RegistrationSynchronizer.this.stats.reportError(MobileMessagingStatsError.PUSH_REGISTRATION_STATUS_UPDATE_ERROR);
                RegistrationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
            }
        }.retryWith(this.retryPolicyProvider.ONE_RETRY()).execute(this.executor, (IN[])new Boolean[]{enabled});
    }

    public void sync() {
        if (this.isRegistrationIdReported() && !this.mobileMessagingCore.isPushServiceTypeChanged()) {
            return;
        }
        this.reportCloudToken(this.mobileMessagingCore.getCloudToken());
    }

    private void reportCloudToken(String cloudToken) {
        if (StringUtils.isBlank(cloudToken)) {
            return;
        }
        new MRetryableTask<String, Registration>(){

            public Registration run(String[] params) {
                String cloudToken = params.length > 0 ? params[0] : null;
                MobileMessagingLogger.v("REGISTRATION >>>", cloudToken);
                RegistrationResponse registrationResponse = RegistrationSynchronizer.this.mobileApiRegistration.upsert(cloudToken, null, Platform.usedPushServiceType);
                MobileMessagingLogger.v("REGISTRATION <<<", registrationResponse);
                return new Registration(cloudToken, registrationResponse.getDeviceApplicationInstanceId(), registrationResponse.getPushRegistrationEnabled());
            }

            @Override
            public void after(Registration registration) {
                RegistrationSynchronizer.this.setPushRegistrationEnabled(registration.enabled);
                RegistrationSynchronizer.this.setPushRegistrationId(registration.registrationId);
                RegistrationSynchronizer.this.setRegistrationIdReported(true);
                RegistrationSynchronizer.this.mobileMessagingCore.setReportedPushServiceType();
                MobileMessagingCore.getInstance(RegistrationSynchronizer.this.context).reportSystemData();
                RegistrationSynchronizer.this.broadcaster.registrationCreated(registration.cloudToken, registration.registrationId);
            }

            @Override
            public void error(Throwable error) {
                MobileMessagingLogger.e("MobileMessaging API returned error (registration)!");
                RegistrationSynchronizer.this.setRegistrationIdReported(false);
                RegistrationSynchronizer.this.mobileMessagingCore.setLastHttpException(error);
                RegistrationSynchronizer.this.stats.reportError(MobileMessagingStatsError.PUSH_REGISTRATION_STATUS_UPDATE_ERROR);
                RegistrationSynchronizer.this.broadcaster.error(MobileMessagingError.createFrom(error));
            }
        }.retryWith(this.retryPolicyProvider.DEFAULT()).execute(this.executor, (IN[])new String[]{cloudToken});
    }

    private void setPushRegistrationEnabled(Boolean pushRegistrationEnabled) {
        if (pushRegistrationEnabled == null) {
            return;
        }
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.PUSH_REGISTRATION_ENABLED, (boolean)pushRegistrationEnabled);
    }

    private void setPushRegistrationId(String registrationId) {
        if (registrationId == null) {
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, registrationId);
    }

    public void setRegistrationIdReported(boolean reported) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED, reported);
    }

    public boolean isRegistrationIdReported() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.CLOUD_TOKEN_REPORTED);
    }
}

