/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.platform;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingJob;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

@TargetApi(value=24)
public class MobileMessagingJobService
extends JobService {
    private static final String TAG = MobileMessagingJobService.class.getSimpleName();
    private MobileMessagingCore mobileMessagingCore;

    public MobileMessagingJobService() {
    }

    @VisibleForTesting
    public MobileMessagingJobService(MobileMessagingCore mobileMessagingCore) {
        this.mobileMessagingCore = mobileMessagingCore;
    }

    public boolean onStartJob(JobParameters params) {
        int connectivityScheduleId = MobileMessagingJob.getScheduleId((Context)this, 1);
        if (params.getJobId() == connectivityScheduleId) {
            MobileMessagingLogger.d(TAG, "Network available");
            this.mobileMessagingCore().retrySyncOnNetworkAvailable();
            return false;
        }
        return false;
    }

    public boolean onStopJob(JobParameters params) {
        return false;
    }

    public static void registerJobForConnectivityUpdates(Context context) {
        MobileMessagingJobService.registerForNetworkAvailability(context);
    }

    @NonNull
    private MobileMessagingCore mobileMessagingCore() {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance((Context)this);
        }
        return this.mobileMessagingCore;
    }

    private static void registerForNetworkAvailability(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler == null) {
            return;
        }
        int scheduleId = MobileMessagingJob.getScheduleId(context, 1);
        jobScheduler.cancel(scheduleId);
        int r = jobScheduler.schedule(new JobInfo.Builder(scheduleId, new ComponentName(context, MobileMessagingJobService.class)).setRequiredNetworkType(1).build());
        if (r == 1) {
            MobileMessagingLogger.d(TAG, "Registered job for connectivity updates");
        } else {
            MobileMessagingLogger.e(TAG, "Failed to register job for connectivity updates");
        }
    }
}

