/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.GeofenceAreas;
import org.infobip.mobile.messaging.util.InternalMessageUtils;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=12)
public class Message
implements Comparable {
    private final Bundle bundle;
    private Gson gson = new Gson();

    public Message() {
        this.bundle = new Bundle();
    }

    public Message(Bundle bundle) {
        this.bundle = bundle;
    }

    public static Message copyFrom(Bundle source) {
        Message sourceMessage = new Message(source);
        Message message = new Message();
        message.setSilent(sourceMessage.isSilent());
        message.setFrom(sourceMessage.getFrom());
        message.setMessageId(sourceMessage.getMessageId());
        message.setTitle(sourceMessage.getTitle());
        message.setBody(sourceMessage.getBody());
        message.setSound(sourceMessage.getSound());
        message.setIcon(sourceMessage.getIcon());
        message.setData(sourceMessage.getData());
        message.setReceivedTimestamp(sourceMessage.getReceivedTimestamp());
        message.setSeenTimestamp(sourceMessage.getSeenTimestamp());
        message.setInternalData(sourceMessage.getInternalData());
        message.setCustomPayload(sourceMessage.getCustomPayload());
        message.setCategory(sourceMessage.getCategory());
        return message;
    }

    public String getMessageId() {
        return this.bundle.getString(Data.MESSAGE_ID.getKey(), null);
    }

    public void setMessageId(String messageId) {
        this.bundle.putString(Data.MESSAGE_ID.getKey(), messageId);
    }

    public List<GeofenceAreas.Area> getGeofenceAreasList() {
        if (TextUtils.isEmpty((CharSequence)this.getInternalData())) {
            return new ArrayList<GeofenceAreas.Area>(0);
        }
        try {
            GeofenceAreas geofenceAreas = (GeofenceAreas)this.gson.fromJson(this.getInternalData(), GeofenceAreas.class);
            return geofenceAreas.getAreasList();
        }
        catch (Exception e) {
            Log.e((String)"MobileMessaging", (String)e.getMessage(), (Throwable)e);
            return new ArrayList<GeofenceAreas.Area>(0);
        }
    }

    public String getFrom() {
        return this.bundle.getString(Data.FROM.getKey(), null);
    }

    public void setFrom(String from) {
        this.bundle.putString(Data.FROM.getKey(), from);
    }

    public String getSound() {
        if (this.isSilent()) {
            return InternalMessageUtils.getSilentSound(this);
        }
        return this.bundle.getString(Data.SOUND.getKey(), null);
    }

    public void setSound(String sound) {
        if (this.isSilent()) {
            InternalMessageUtils.setSilentSound(this, sound);
        } else {
            this.bundle.putString(Data.SOUND.getKey(), sound);
        }
    }

    public String getIcon() {
        return this.bundle.getString(Data.ICON.getKey(), null);
    }

    public void setIcon(String icon) {
        this.bundle.putString(Data.ICON.getKey(), icon);
    }

    public String getBody() {
        if (this.isSilent()) {
            return InternalMessageUtils.getSilentBody(this);
        }
        return this.bundle.getString(Data.BODY.getKey(), null);
    }

    public void setBody(String body) {
        if (this.isSilent()) {
            InternalMessageUtils.setSilentBody(this, body);
        } else {
            this.bundle.putString(Data.BODY.getKey(), body);
        }
    }

    public String getTitle() {
        if (this.isSilent()) {
            return InternalMessageUtils.getSilentTitle(this);
        }
        return this.bundle.getString(Data.TITLE.getKey(), null);
    }

    public void setTitle(String title) {
        if (this.isSilent()) {
            InternalMessageUtils.setSilentTitle(this, title);
        } else {
            this.bundle.putString(Data.TITLE.getKey(), title);
        }
    }

    public Bundle getData() {
        return this.bundle.getBundle(Data.DATA.getKey());
    }

    public void setData(Bundle data) {
        this.bundle.putBundle(Data.DATA.getKey(), data);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean isSilent() {
        return "true".equals(this.bundle.getString(Data.SILENT.getKey()));
    }

    public void setSilent(boolean silent) {
        this.bundle.putString(Data.SILENT.getKey(), silent ? "true" : "false");
    }

    public long getReceivedTimestamp() {
        return this.bundle.getLong(Data.RECEIVED_TIMESTAMP.getKey(), System.currentTimeMillis());
    }

    public void setReceivedTimestamp(long receivedTimestamp) {
        this.bundle.putLong(Data.RECEIVED_TIMESTAMP.getKey(), receivedTimestamp);
    }

    public long getSeenTimestamp() {
        return this.bundle.getLong(Data.SEEN_TIMESTAMP.getKey(), 0L);
    }

    public void setSeenTimestamp(long receivedTimestamp) {
        this.bundle.putLong(Data.SEEN_TIMESTAMP.getKey(), receivedTimestamp);
    }

    public JSONObject getCustomPayload() {
        return this.getJSON(Data.CUSTOM_PAYLOAD.getKey());
    }

    public void setCustomPayload(JSONObject customPayload) {
        if (customPayload == null) {
            return;
        }
        this.bundle.putString(Data.CUSTOM_PAYLOAD.getKey(), customPayload.toString());
    }

    public String getInternalData() {
        return this.bundle.getString(Data.INTERNAL_DATA.getKey());
    }

    public void setInternalData(String data) {
        this.bundle.putString(Data.INTERNAL_DATA.getKey(), data);
    }

    public String getCategory() {
        return this.bundle.getString(Data.CATEGORY.getKey());
    }

    public void setCategory(String category) {
        this.bundle.putString(Data.CATEGORY.getKey(), category);
    }

    private JSONObject getJSON(String key) {
        String string = this.bundle.getString(key);
        if (string == null) {
            return null;
        }
        try {
            return new JSONObject(string);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int compareTo(Object another) {
        if (!(another instanceof Message)) {
            return 1;
        }
        Message message = (Message)another;
        return (int)Math.signum(message.getReceivedTimestamp() - this.getReceivedTimestamp());
    }

    protected static enum Data {
        MESSAGE_ID("gcm.notification.messageId"),
        TITLE("gcm.notification.title"),
        BODY("gcm.notification.body"),
        SOUND("gcm.notification.sound"),
        ICON("gcm.notification.icon"),
        SILENT("gcm.notification.silent"),
        CATEGORY("gcm.notification.category"),
        FROM("from"),
        RECEIVED_TIMESTAMP("received_timestamp"),
        SEEN_TIMESTAMP("seen_timestamp"),
        DATA("data"),
        INTERNAL_DATA("internalData"),
        CUSTOM_PAYLOAD("customPayload");

        private final String key;

        private Data(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

