/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;

public class MoMessage {
    String destination;
    String text;
    Map<String, Object> customPayload;
    protected String messageId;
    protected Status status;
    protected String statusMessage;

    public MoMessage(String destination, String text, Map<String, Object> customPayload) {
        this.destination = destination;
        this.text = text;
        this.customPayload = customPayload;
        this.messageId = "";
        this.status = Status.UNKNOWN;
        this.statusMessage = "";
    }

    public MoMessage() {
        this.destination = null;
        this.text = null;
        this.customPayload = new HashMap<String, Object>();
    }

    private MoMessage(String message) {
        JsonSerializer jsonSerializer = new JsonSerializer();
        MoMessage moMessage = (MoMessage)jsonSerializer.deserialize(message, MoMessage.class);
        this.destination = moMessage.destination;
        this.text = moMessage.text;
        this.customPayload = moMessage.customPayload;
        this.messageId = moMessage.messageId;
        this.status = moMessage.status;
        this.statusMessage = moMessage.statusMessage;
    }

    public static MoMessage[] createFrom(List<String> messages) {
        ArrayList<Object> moMessages = new ArrayList<Object>();
        JsonSerializer jsonSerializer = new JsonSerializer();
        for (String message : messages) {
            moMessages.add(jsonSerializer.deserialize(message, MoMessage.class));
        }
        return moMessages.toArray(new MoMessage[moMessages.size()]);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, Object> getCustomPayload() {
        return this.customPayload;
    }

    public void setCustomPayload(Map<String, Object> customPayload) {
        this.customPayload = customPayload;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public static enum Status {
        SUCCESS,
        ERROR,
        UNKNOWN;

    }
}

