/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.gson.Gson;
import org.infobip.mobile.messaging.Actionable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.gcm.NotificationActionReceiver;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

class MobileMessageHandler {
    public static final int CHAT_NOTIFICATION_ID = 1;
    public static final int COUPON_NOTIFICATION_ID = 2;
    public static final int DEFAULT_NOTIFICATION_ID = 0;
    private NotificationSettings notificationSettings;

    MobileMessageHandler() {
    }

    void handleNotification(Context context, Intent intent) {
        String from = intent.getStringExtra("from");
        Bundle data = intent.getExtras();
        data.putLong("received_timestamp", System.currentTimeMillis());
        Log.d((String)"MobileMessaging", (String)("Message received from: " + from));
        Message message = this.createMessage(from, data);
        this.sendDeliveryReport(context, message);
        this.saveMessage(context, message);
        Log.d((String)"MobileMessaging", (String)("Message is silent: " + message.isSilent()));
        if (!message.isSilent()) {
            String category = message.getCategory();
            if ("chatMessage".equalsIgnoreCase(category)) {
                this.displayChatNotification(context, message);
            } else if ("chatCoupon".equalsIgnoreCase(category)) {
                this.displayCouponNotification(context, message);
            } else {
                this.displayNotification(context, message);
            }
        }
        Intent messageReceived = new Intent(Event.MESSAGE_RECEIVED.getKey());
        messageReceived.putExtras(message.getBundle());
        context.sendBroadcast(messageReceived);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messageReceived);
    }

    private void displayNotification(Context context, Message message) {
        NotificationCompat.Builder builder = this.notificationCompatBuilder(context, message);
        if (builder == null) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = builder.build();
        notificationManager.notify(0, notification);
    }

    private void displayChatNotification(Context context, Message message) {
        NotificationCompat.Builder builder = this.notificationCompatBuilder(context, message);
        if (builder == null) {
            return;
        }
        Intent markSeenIntent = new Intent(context, NotificationActionReceiver.class);
        markSeenIntent.setAction("org.infobip.mobile.messaging.gcm.ACTION_MARK_SEEN");
        markSeenIntent.putExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey(), message.getBundle());
        PendingIntent pendingIntentMarkSeen = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)markSeenIntent, (int)0x8000000);
        NotificationCompat.Action markSeenAction = new NotificationCompat.Action(0, (CharSequence)this.notificationSettings.getMarkSeenActionTitle(), pendingIntentMarkSeen);
        Intent replyIntent = new Intent(context, NotificationActionReceiver.class);
        replyIntent.setAction("org.infobip.mobile.messaging.gcm.ACTION_REPLY");
        replyIntent.putExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey(), message.getBundle());
        PendingIntent pendingIntentReply = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)replyIntent, (int)0x8000000);
        NotificationCompat.Action replyAction = new NotificationCompat.Action(0, (CharSequence)this.notificationSettings.getReplyActionTitle(), pendingIntentReply);
        builder.addAction(markSeenAction);
        builder.addAction(replyAction);
        builder.setPriority(1);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = builder.build();
        notificationManager.notify(1, notification);
    }

    private void displayCouponNotification(Context context, Message message) {
        NotificationCompat.Builder builder = this.notificationCompatBuilder(context, message);
        if (builder == null) {
            return;
        }
        Gson gson = new Gson();
        Actionable actionable = (Actionable)gson.fromJson(message.getInternalData(), Actionable.class);
        if (actionable != null && actionable.getInteractive() != null) {
            Actionable.Interactive interactive = actionable.getInteractive();
            String couponUrl = interactive.getButtonActions().getCouponUrl();
            Intent openUrlIntent = new Intent(context, NotificationActionReceiver.class);
            openUrlIntent.setAction("org.infobip.mobile.messaging.gcm.ACTION_COUPON_URL");
            openUrlIntent.putExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey(), message.getBundle());
            openUrlIntent.putExtra("couponUrl", couponUrl);
            PendingIntent pendingIntentOpenUrl = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)openUrlIntent, (int)0x8000000);
            NotificationCompat.Action openUrlAction = new NotificationCompat.Action(0, (CharSequence)this.notificationSettings.getOpenUrlActionTitle(), pendingIntentOpenUrl);
            builder.addAction(openUrlAction);
            builder.setPriority(1);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            Notification notification = builder.build();
            notificationManager.notify(2, notification);
        } else {
            Log.e((String)"MobileMessaging", (String)"Unable to parse internalData.interactive object", (Throwable)new Throwable("interactive json object may be mailformed"));
        }
    }

    private void saveMessage(Context context, Message message) {
        if (!MobileMessagingCore.getInstance(context).isMessageStoreEnabled()) {
            Log.d((String)"MobileMessaging", (String)("Skipping save message: " + message.getMessageId()));
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Saving message: " + message.getMessageId()));
        try {
            MobileMessagingCore.getInstance(context).getMessageStore().save(context, message);
        }
        catch (Exception e) {
            Log.e((String)"MobileMessaging", (String)("Error saving message: " + message.getMessageId()), (Throwable)e);
        }
    }

    private Message createMessage(String from, Bundle data) {
        Message message = Message.copyFrom(data);
        message.setFrom(from);
        message.setData(data);
        return message;
    }

    private void sendDeliveryReport(Context context, Message message) {
        if (StringUtils.isBlank(message.getMessageId())) {
            Log.e((String)"MobileMessaging", (String)("No ID received for message: " + message));
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Sending DR: " + message.getMessageId()));
        MobileMessagingCore.getInstance(context).setMessagesDelivered(message.getMessageId());
    }

    private NotificationCompat.Builder notificationCompatBuilder(Context context, Message message) {
        this.notificationSettings = this.notificationSettings(context, message);
        if (this.notificationSettings == null) {
            return null;
        }
        Intent intent = new Intent(context, this.notificationSettings.getCallbackActivity());
        intent.putExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey(), message.getBundle());
        intent.addFlags(this.notificationSettings.getIntentFlags());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)this.notificationSettings.getPendingIntentFlags());
        String title = StringUtils.isNotBlank(message.getTitle()) ? message.getTitle() : this.notificationSettings.getDefaultTitle();
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context).setDefaults(this.notificationSettings.getNotificationDefaults()).setContentTitle((CharSequence)title).setContentText((CharSequence)message.getBody()).setAutoCancel(this.notificationSettings.isNotificationAutoCancel()).setContentIntent(pendingIntent).setWhen(message.getReceivedTimestamp());
        int icon = StringUtils.isNotBlank(message.getIcon()) ? ResourceLoader.loadResourceByName(context, "drawable", message.getIcon()) : this.notificationSettings.getDefaultIcon();
        notificationBuilder.setSmallIcon(icon);
        return notificationBuilder;
    }

    private NotificationSettings notificationSettings(Context context, Message message) {
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance(context).getNotificationSettings();
        if (null == notificationSettings) {
            return null;
        }
        if (!notificationSettings.isDisplayNotificationEnabled() || null == notificationSettings.getCallbackActivity()) {
            return null;
        }
        if (StringUtils.isBlank(message.getBody())) {
            return null;
        }
        if (ActivityLifecycleMonitor.isForeground() && notificationSettings.isForegroundNotificationDisabled()) {
            return null;
        }
        return notificationSettings;
    }
}

