/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;

public class NotificationActionReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        int notificationId;
        Bundle bundle = intent.getBundleExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey());
        if (bundle == null) {
            return;
        }
        Message message = new Message(bundle);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        String action = intent.getAction();
        if (action == null) {
            return;
        }
        switch (action) {
            case "org.infobip.mobile.messaging.gcm.ACTION_MARK_SEEN": {
                MobileMessagingCore.getInstance(context).setMessagesSeen(message.getMessageId());
                notificationId = 1;
                break;
            }
            case "org.infobip.mobile.messaging.gcm.ACTION_REPLY": {
                MobileMessaging.OnReplyClickListener onReplyClickListener = MobileMessagingCore.getInstance(context).getOnReplyClickListener();
                if (onReplyClickListener != null) {
                    onReplyClickListener.onReplyClicked(intent);
                }
                notificationId = 1;
                break;
            }
            case "org.infobip.mobile.messaging.gcm.ACTION_COUPON_URL": {
                String stringUrl = intent.getStringExtra("couponUrl");
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)stringUrl));
                i.setFlags(0x10000000);
                context.startActivity(i);
                notificationId = 2;
                break;
            }
            default: {
                notificationId = 0;
            }
        }
        notificationManager.cancel(notificationId);
    }
}

