/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.reporters;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MoMessage;
import org.infobip.mobile.messaging.api.messages.MoMessageDelivery;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.SendMessageResult;
import org.infobip.mobile.messaging.tasks.SendMessageTask;

public class MessageReporter {
    public void send(final Context context, final MobileMessagingStats stats, Executor executor, final MoMessage ... messages) {
        new SendMessageTask(context){

            protected void onPostExecute(SendMessageResult sendMessageResult) {
                if (sendMessageResult.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                    stats.reportError(MobileMessagingError.MESSAGE_SEND_ERROR);
                    Intent sendMessageError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    sendMessageError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)sendMessageResult.getError());
                    context.sendBroadcast(sendMessageError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(sendMessageError);
                    MessageReporter.this.reportFailedMessages(context, sendMessageResult.getError().getMessage(), messages);
                    return;
                }
                ArrayList<String> moMessages = new ArrayList<String>();
                JsonSerializer jsonSerializer = new JsonSerializer();
                for (MoMessageDelivery delivery : sendMessageResult.getMessageDeliveries()) {
                    MoDeliveredMessage message = new MoDeliveredMessage(delivery.getDestination(), delivery.getText(), delivery.getCustomPayload(), delivery.getMessageId(), delivery.getStatusCode(), delivery.getStatus());
                    moMessages.add(jsonSerializer.serialize((Object)message));
                }
                Intent messagesSent = new Intent(Event.MESSAGES_SENT.getKey());
                messagesSent.putStringArrayListExtra("org.infobip.mobile.messaging.mo.messages", moMessages);
                context.sendBroadcast(messagesSent);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messagesSent);
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error sending messages!");
                stats.reportError(MobileMessagingError.MESSAGE_SEND_ERROR);
                MessageReporter.this.reportFailedMessages(context, "Network error", messages);
            }
        }.executeOnExecutor(executor, messages);
    }

    private void reportFailedMessages(Context context, String errorMessage, MoMessage ... messages) {
        ArrayList<String> moMessages = new ArrayList<String>();
        JsonSerializer jsonSerializer = new JsonSerializer();
        for (MoMessage message : messages) {
            MoDeliveredMessage moMessage = new MoDeliveredMessage(message.getDestination(), message.getText(), message.getCustomPayload(), message.getMessageId(), 1, errorMessage);
            moMessages.add(jsonSerializer.serialize((Object)moMessage));
        }
        Intent messagesSent = new Intent(Event.MESSAGES_SENT.getKey());
        messagesSent.putStringArrayListExtra("org.infobip.mobile.messaging.mo.messages", moMessages);
        context.sendBroadcast(messagesSent);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messagesSent);
    }

    class MoDeliveredMessage
    extends MoMessage {
        private static final int STATUS_ID_SENT = 0;
        private static final int STATUS_ID_ERROR = 1;

        public MoDeliveredMessage(String destination, String text, Map<String, Object> customPayload, String messageId, int statusId, String statusMessage) {
            super(destination, text, customPayload);
            this.messageId = messageId;
            this.status = this.getStatusFromStatusId(statusId);
            this.statusMessage = statusMessage;
        }

        MoMessage.Status getStatusFromStatusId(int statusId) {
            switch (statusId) {
                case 0: {
                    return MoMessage.Status.SUCCESS;
                }
                case 1: {
                    return MoMessage.Status.ERROR;
                }
            }
            return MoMessage.Status.UNKNOWN;
        }
    }
}

