/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.reporters;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.reporters.BatchReporter;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.SeenStatusReportResult;
import org.infobip.mobile.messaging.tasks.SeenStatusReportTask;

public class SeenStatusReporter {
    private static BatchReporter batchReporter = null;

    public void report(final Context context, String[] unreportedSeenMessageIds, final MobileMessagingStats stats, final Executor executor) {
        if (unreportedSeenMessageIds.length == 0) {
            return;
        }
        if (batchReporter == null) {
            batchReporter = new BatchReporter(context);
        }
        batchReporter.put(new Runnable(){

            @Override
            public void run() {
                new SeenStatusReportTask(context){

                    protected void onPostExecute(SeenStatusReportResult result) {
                        if (result.hasError()) {
                            Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                            stats.reportError(MobileMessagingError.SEEN_REPORTING_ERROR);
                            Intent seenStatusReportError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                            seenStatusReportError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)result.getError());
                            context.sendBroadcast(seenStatusReportError);
                            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(seenStatusReportError);
                            return;
                        }
                        Intent seenReportsSent = new Intent(Event.SEEN_REPORTS_SENT.getKey());
                        Bundle extras = new Bundle();
                        extras.putStringArray("org.infobip.mobile.messaging.message.ids", result.getMessageIDs());
                        seenReportsSent.putExtras(extras);
                        context.sendBroadcast(seenReportsSent);
                        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(seenReportsSent);
                    }

                    protected void onCancelled() {
                        stats.reportError(MobileMessagingError.SEEN_REPORTING_ERROR);
                        Log.e((String)"MobileMessaging", (String)"Error reporting seen status!");
                    }
                }.executeOnExecutor(executor, new Object[0]);
            }
        });
    }
}

