/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.reporters;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.SyncUserDataResult;
import org.infobip.mobile.messaging.tasks.SyncUserDataTask;

public class UserDataSynchronizer {
    public void sync(final Context context, final MobileMessagingStats stats, Executor executor) {
        if (MobileMessagingCore.getInstance(context).getUnreportedUserData() == null) {
            return;
        }
        new SyncUserDataTask(context){

            protected void onPostExecute(SyncUserDataResult syncUserDataResult) {
                if (syncUserDataResult.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                    stats.reportError(MobileMessagingError.USER_DATA_SYNC_ERROR);
                    if (syncUserDataResult.hasInvalidParameterError()) {
                        MobileMessagingCore.getInstance(context).setUserDataReportedWithError();
                    }
                    Intent userDataSyncError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    userDataSyncError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)syncUserDataResult.getError());
                    context.sendBroadcast(userDataSyncError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(userDataSyncError);
                    return;
                }
                UserData userData = new UserData(syncUserDataResult.getPredefined(), syncUserDataResult.getCustom());
                MobileMessagingCore.getInstance(context).setUserDataReported(userData);
                Intent userDataReported = new Intent(Event.USER_DATA_REPORTED.getKey());
                userDataReported.putExtra("org.infobip.mobile.messaging.userdata", userData.toString());
                context.sendBroadcast(userDataReported);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(userDataReported);
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error reporting user data!");
                stats.reportError(MobileMessagingError.USER_DATA_SYNC_ERROR);
            }
        }.executeOnExecutor(executor, new Void[0]);
    }
}

