/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MoMessage;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.messages.MoMessagesBody;
import org.infobip.mobile.messaging.api.messages.MoMessagesResponse;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;
import org.infobip.mobile.messaging.tasks.SendMessageResult;
import org.infobip.mobile.messaging.util.StringUtils;

public class SendMessageTask
extends AsyncTask<MoMessage, Void, SendMessageResult> {
    private final Context context;

    public SendMessageTask(Context context) {
        this.context = context;
    }

    protected SendMessageResult doInBackground(MoMessage ... messages) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't send messages to MobileMessaging API without valid registration!");
            return new SendMessageResult(new Exception("No valid registration"));
        }
        try {
            MoMessagesBody moMessagesBody = new MoMessagesBody();
            moMessagesBody.setFrom(deviceApplicationInstanceId);
            ArrayList<org.infobip.mobile.messaging.api.messages.MoMessage> moMessages = new ArrayList<org.infobip.mobile.messaging.api.messages.MoMessage>();
            for (MoMessage message : messages) {
                moMessages.add(new org.infobip.mobile.messaging.api.messages.MoMessage(message.getMessageId(), message.getDestination(), message.getText(), message.getCustomPayload()));
            }
            moMessagesBody.setMessages(moMessages.toArray(new org.infobip.mobile.messaging.api.messages.MoMessage[moMessages.size()]));
            MoMessagesResponse moMessagesResponse = MobileApiResourceProvider.INSTANCE.getMobileApiMessages(this.context).sendMO(moMessagesBody);
            return new SendMessageResult(moMessagesResponse.getMessages());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error sending MO messages!", (Throwable)e);
            this.cancel(true);
            Intent sendMessagesError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            sendMessagesError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(sendMessagesError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(sendMessagesError);
            return new SendMessageResult(e);
        }
    }
}

