/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.location.Geofence;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infobip.mobile.messaging.util.DateTimeUtil;

public class GeofenceAreas
implements Parcelable {
    @SerializedName(value="triggeringLatitude")
    private Double triggeringLatitude;
    @SerializedName(value="triggeringLongitude")
    private Double triggeringLongitude;
    @SerializedName(value="geo")
    private List<Area> areasList = new ArrayList<Area>();
    public static final Parcelable.Creator<GeofenceAreas> CREATOR = new Parcelable.Creator<GeofenceAreas>(){

        public GeofenceAreas createFromParcel(Parcel in) {
            return new GeofenceAreas(in);
        }

        public GeofenceAreas[] newArray(int size) {
            return new GeofenceAreas[size];
        }
    };

    public GeofenceAreas(Double triggeringLatitude, Double triggeringLongitude, List<Area> areasList) {
        this.triggeringLatitude = triggeringLatitude;
        this.triggeringLongitude = triggeringLongitude;
        this.areasList = areasList;
    }

    protected GeofenceAreas(Parcel in) {
        this.triggeringLatitude = in.readDouble();
        this.triggeringLongitude = in.readDouble();
        in.readTypedList(this.areasList, Area.CREATOR);
    }

    public Double getTriggeringLatitude() {
        return this.triggeringLatitude;
    }

    public Double getTriggeringLongitude() {
        return this.triggeringLongitude;
    }

    public List<Area> getAreasList() {
        return this.areasList;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeDouble(this.triggeringLatitude.doubleValue());
        parcel.writeDouble(this.triggeringLongitude.doubleValue());
        parcel.writeTypedList(this.areasList);
    }

    public static class Area
    implements Parcelable {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="title")
        private String title;
        @SerializedName(value="latitude")
        private Double latitude;
        @SerializedName(value="longitude")
        private Double longitude;
        @SerializedName(value="radiusInMeters")
        private Integer radius;
        @SerializedName(value="expiryTime")
        private String expiryTime;
        public static final Parcelable.Creator<Area> CREATOR = new Parcelable.Creator<Area>(){

            public Area createFromParcel(Parcel in) {
                return new Area(in);
            }

            public Area[] newArray(int size) {
                return new Area[size];
            }
        };

        public Area(String id, String title, Double latitude, Double longitude, Integer radius, String expiryTime) {
            this.id = id;
            this.title = title;
            this.latitude = latitude;
            this.longitude = longitude;
            this.radius = radius;
            this.expiryTime = expiryTime;
        }

        protected Area(Parcel in) {
            this.id = in.readString();
            this.title = in.readString();
            this.latitude = in.readDouble();
            this.longitude = in.readDouble();
            this.radius = in.readInt();
            this.expiryTime = in.readString();
        }

        public String getExpiryTime() {
            return this.expiryTime;
        }

        public Date getExpiryDate() {
            return DateTimeUtil.ISO8601DateFromString(this.expiryTime);
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public Integer getRadius() {
            return this.radius;
        }

        public Geofence toGeofence() {
            Long expirationDurationMillis = 0L;
            Date expiryDate = this.getExpiryDate();
            if (expiryDate != null) {
                expirationDurationMillis = expiryDate.getTime() - System.currentTimeMillis();
            }
            if (expirationDurationMillis <= 0L) {
                expirationDurationMillis = -1L;
            }
            return new Geofence.Builder().setCircularRegion(this.getLatitude().doubleValue(), this.getLongitude().doubleValue(), (float)this.getRadius().intValue()).setRequestId(this.getId()).setTransitionTypes(1).setExpirationDuration(expirationDurationMillis.longValue()).build();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeString(this.id);
            parcel.writeString(this.title);
            parcel.writeDouble(this.latitude.doubleValue());
            parcel.writeDouble(this.longitude.doubleValue());
            parcel.writeInt(this.radius.intValue());
            parcel.writeString(this.expiryTime);
        }

        public boolean isValid() {
            return this.getId() != null && this.getExpiryTime() != null && this.getLatitude() != null && this.getLongitude() != null && this.getRadius() != null;
        }
    }
}

