/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.List;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.GeofenceAreas;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.geo.GeofenceTransitionsIntentService;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.SharedPreferencesMessageStore;

public class Geofencing
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static final int ACCESS_FINE_LOCATION_PERMISSION_REQUEST_CODE = 100;
    private static String TAG = "MobileMessaging/Geofencing";
    private static Context context;
    private static Geofencing instance;
    private GoogleApiClient googleApiClient;
    private List<Geofence> geofences;
    private PendingIntent geofencePendingIntent;
    private MessageStore messageStore;

    private Geofencing(Context context) {
        Geofencing.context = context;
        this.geofences = new ArrayList<Geofence>();
        this.messageStore = new SharedPreferencesMessageStore();
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    public static Geofencing getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        instance = new Geofencing(context);
        return instance;
    }

    void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 100 && grantResults.length > 0 && grantResults[0] == 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.activate();
        }
    }

    void activate() {
        this.checkRequiredService(context, GeofenceTransitionsIntentService.class);
        if (PlayServicesSupport.isPlayServicesAvailable() && MobileMessagingCore.isGeofencingActivated(context)) {
            this.addGeofenceAreasToPlayServices();
            this.activateGeofences();
        }
    }

    void addGeofenceAreasToPlayServices() {
        List<Message> messages = this.messageStore.bind(context);
        if (!messages.isEmpty()) {
            this.geofences.clear();
            for (Message message : messages) {
                List<GeofenceAreas.Area> geoAreasList = message.getGeofenceAreasList();
                if (geoAreasList == null || geoAreasList.isEmpty()) continue;
                for (GeofenceAreas.Area area : geoAreasList) {
                    if (!area.isValid()) continue;
                    this.geofences.add(area.toGeofence());
                }
            }
        }
    }

    private void activateGeofences() {
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        if (!(context instanceof Activity)) {
            Log.e((String)TAG, (String)"You shall provide instance of Activity as context for geofencing!");
            return;
        }
        Activity activity = (Activity)context;
        if (ActivityCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            String[] permissions = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)100);
            return;
        }
        if (this.geofences.isEmpty()) {
            Log.d((String)TAG, (String)"Skip adding geofences. No geofence areas to add.");
            return;
        }
        LocationServices.GeofencingApi.addGeofences(this.googleApiClient, this.geofencingRequest(), this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                MobileMessagingCore.setGeofencingActivated(context, status.isSuccess());
                Geofencing.this.logGeofenceStatus(status, true);
            }
        });
    }

    void deactivate() {
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("You shall provide instance of Activity as context for geofencing!");
        }
        Activity activity = (Activity)context;
        if (ActivityCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            String[] permissions = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)100);
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                MobileMessagingCore.setGeofencingActivated(context, !status.isSuccess());
                Geofencing.this.logGeofenceStatus(status, false);
            }
        });
    }

    private void checkRequiredService(Context context, Class serviceClass) {
        String serviceName = serviceClass.getCanonicalName();
        ComponentName componentName = new ComponentName(context.getPackageName(), serviceName);
        try {
            context.getPackageManager().getServiceInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            throw new ConfigurationException(String.format(ConfigurationException.Reason.MISSING_REQUIRED_SERVICE.message(), serviceName));
        }
    }

    private void logGeofenceStatus(@NonNull Status status, boolean activated) {
        if (status.isSuccess()) {
            Log.d((String)TAG, (String)("Geofencing monitoring " + (activated ? "" : "de-") + "activated successfully"));
        } else {
            Log.e((String)TAG, (String)("Geofencing monitoring " + (activated ? "" : "de-") + "activation failed"), (Throwable)new Throwable(status.getStatusMessage()));
        }
    }

    private GeofencingRequest geofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.geofences);
        return builder.build();
    }

    private PendingIntent geofencePendingIntent() {
        if (this.geofencePendingIntent == null) {
            Intent intent = new Intent(context, GeofenceTransitionsIntentService.class);
            this.geofencePendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        }
        return this.geofencePendingIntent;
    }

    public void onConnected(@Nullable Bundle bundle) {
        Log.d((String)TAG, (String)"GoogleApiClient connected");
        this.activateGeofences();
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Log.e((String)TAG, (String)connectionResult.getErrorMessage(), (Throwable)new ConfigurationException(ConfigurationException.Reason.CHECK_LOCATION_SETTINGS));
    }
}

