/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.infobip.mobile.messaging.GeofenceAreas;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.json.JSONException;
import org.json.JSONObject;

public class Message
implements Comparable<Message> {
    Bundle bundle;
    String messageId;
    String title;
    String body;
    String sound;
    boolean vibrate;
    String icon;
    boolean silent;
    String category;
    String from;
    Long receivedTimestamp;
    Long seenTimestamp;
    JSONObject internalData;
    JSONObject customPayload;
    String destination;
    Status status;
    String statusMessage;

    public static Message createFrom(Bundle bundle) {
        return new Message(bundle);
    }

    public static List<Message> createFrom(ArrayList<Bundle> bundles) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Bundle bundle : bundles) {
            messages.add(Message.createFrom(bundle));
        }
        return messages;
    }

    public Message() {
        this.messageId = UUID.randomUUID().toString();
        this.status = Status.UNKNOWN;
        this.receivedTimestamp = System.currentTimeMillis();
        this.vibrate = true;
        this.bundle = new Bundle();
        this.bundle.putString(BundleField.MESSAGE_ID.getKey(), this.messageId);
        this.bundle.putString(BundleField.STATUS.getKey(), this.status.getKey());
        this.bundle.putLong(BundleField.RECEIVED_TIMESTAMP.getKey(), this.receivedTimestamp.longValue());
    }

    private Message(Bundle bundle) {
        this.bundle = bundle;
        this.silent = "true".equals(bundle.getString(BundleField.SILENT.getKey()));
        this.vibrate = "true".equals(bundle.getString(BundleField.VIBRATE.getKey(), "true"));
        this.messageId = bundle.getString(BundleField.MESSAGE_ID.getKey());
        this.icon = bundle.getString(BundleField.ICON.getKey());
        this.from = bundle.getString(BundleField.FROM.getKey());
        this.receivedTimestamp = bundle.getLong(BundleField.RECEIVED_TIMESTAMP.getKey());
        this.seenTimestamp = bundle.getLong(BundleField.SEEN_TIMESTAMP.getKey());
        this.internalData = Message.getJSON(bundle, BundleField.INTERNAL_DATA.getKey());
        this.customPayload = Message.getJSON(bundle, BundleField.CUSTOM_PAYLOAD.getKey());
        this.destination = bundle.getString(BundleField.DESTINATION.getKey());
        try {
            this.status = Status.valueOf(bundle.getString(BundleField.STATUS.getKey()));
        }
        catch (Exception ignored) {
            this.status = Status.UNKNOWN;
        }
        this.statusMessage = bundle.getString(BundleField.STATUS_MESSAGE.getKey());
        if (this.silent) {
            this.title = (String)this.getSilentField(InternalDataField.TITLE.getKey());
            this.body = (String)this.getSilentField(InternalDataField.BODY.getKey());
            this.sound = (String)this.getSilentField(InternalDataField.SOUND.getKey());
            this.category = (String)this.getSilentField(InternalDataField.CATEGORY.getKey());
        } else {
            this.title = bundle.getString(BundleField.TITLE.getKey());
            this.body = bundle.getString(BundleField.BODY.getKey());
            this.sound = bundle.getString(BundleField.SOUND2.getKey(), bundle.getString(BundleField.SOUND.getKey()));
            this.category = bundle.getString(BundleField.CATEGORY.getKey());
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public int compareTo(@NonNull Message another) {
        return (int)Math.signum(another.getReceivedTimestamp() - this.getReceivedTimestamp());
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getSound() {
        return this.sound;
    }

    public boolean isDefaultSound() {
        return "default".equals(this.sound);
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFrom() {
        return this.from;
    }

    public Long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public Long getSeenTimestamp() {
        return this.seenTimestamp;
    }

    public JSONObject getInternalData() {
        return this.internalData;
    }

    public JSONObject getCustomPayload() {
        return this.customPayload;
    }

    public String getDestination() {
        return this.destination;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isVibrate() {
        return this.vibrate;
    }

    public List<GeofenceAreas.Area> getGeofenceAreasList() {
        if (this.getInternalData() == null) {
            return new ArrayList<GeofenceAreas.Area>(0);
        }
        try {
            GeofenceAreas geofenceAreas = (GeofenceAreas)new JsonSerializer().deserialize(this.getInternalData().toString(), GeofenceAreas.class);
            return geofenceAreas.getAreasList();
        }
        catch (Exception e) {
            Log.e((String)"MobileMessaging", (String)e.getMessage(), (Throwable)e);
            return new ArrayList<GeofenceAreas.Area>(0);
        }
    }

    private static JSONObject getJSON(Bundle from, String key) {
        String string = from.getString(key);
        if (string == null) {
            return null;
        }
        try {
            return new JSONObject(string);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> T getSilentField(String key) {
        return this.getSilentField(key, null);
    }

    private <T> T getSilentField(String key, T defaultValue) {
        JSONObject internalData = Message.getJSON(this.bundle, BundleField.INTERNAL_DATA.getKey());
        if (internalData == null) {
            return defaultValue;
        }
        JSONObject silentData = internalData.optJSONObject(InternalDataField.SILENT_DATA.getKey());
        if (silentData == null) {
            return defaultValue;
        }
        Object o = silentData.opt(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (T)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public void setFrom(String from) {
        this.from = from;
        this.bundle.putString(BundleField.FROM.getKey(), from);
    }

    public void setBody(String body) {
        this.body = body;
        this.bundle.putString(BundleField.BODY.getKey(), body);
    }

    public void setDestination(String destination) {
        this.destination = destination;
        this.bundle.putString(BundleField.DESTINATION.getKey(), destination);
    }

    public void setCustomPayload(JSONObject customPayload) {
        this.customPayload = customPayload;
        if (customPayload != null) {
            this.bundle.putString(BundleField.CUSTOM_PAYLOAD.getKey(), customPayload.toString());
        }
    }

    public void setSeenTimestamp(long seenTimestamp) {
        this.seenTimestamp = seenTimestamp;
        this.bundle.putLong(BundleField.SEEN_TIMESTAMP.getKey(), seenTimestamp);
    }

    public void setTitle(String title) {
        this.title = title;
        this.bundle.putString(BundleField.TITLE.getKey(), title);
    }

    public void setInternalData(JSONObject internalData) {
        this.internalData = internalData;
        if (internalData != null) {
            this.bundle.putString(BundleField.INTERNAL_DATA.getKey(), internalData.toString());
        }
    }

    public static enum Status {
        SUCCESS("SUCCESS"),
        ERROR("ERROR"),
        UNKNOWN("UNKNOWN");

        private final String key;

        private Status(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    protected static enum InternalDataField {
        SILENT_DATA("silent"),
        TITLE("title"),
        BODY("body"),
        SOUND("sound"),
        VIBRATE("vibrate"),
        CATEGORY("category");

        private final String key;

        private InternalDataField(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    protected static enum BundleField {
        MESSAGE_ID("gcm.notification.messageId"),
        TITLE("gcm.notification.title"),
        BODY("gcm.notification.body"),
        SOUND("gcm.notification.sound"),
        SOUND2("gcm.notification.sound2"),
        VIBRATE("gcm.notification.vibrate"),
        ICON("gcm.notification.icon"),
        SILENT("gcm.notification.silent"),
        CATEGORY("gcm.notification.category"),
        FROM("from"),
        RECEIVED_TIMESTAMP("received_timestamp"),
        SEEN_TIMESTAMP("seen_timestamp"),
        INTERNAL_DATA("internalData"),
        CUSTOM_PAYLOAD("customPayload"),
        STATUS("status"),
        STATUS_MESSAGE("status_message"),
        DESTINATION("destination");

        private final String key;

        private BundleField(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

