/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.infobip.mobile.messaging.Geofencing;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageStoreInstantiationException;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.reporters.DeliveryReporter;
import org.infobip.mobile.messaging.reporters.MessageReporter;
import org.infobip.mobile.messaging.reporters.RegistrationSynchronizer;
import org.infobip.mobile.messaging.reporters.SeenStatusReporter;
import org.infobip.mobile.messaging.reporters.SystemDataReporter;
import org.infobip.mobile.messaging.reporters.UserDataSynchronizer;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.telephony.MobileNetworkStateListener;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.ExceptionUtils;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;

public class MobileMessagingCore {
    private static MobileMessagingCore instance;
    private final RegistrationSynchronizer registrationSynchronizer = new RegistrationSynchronizer();
    private final DeliveryReporter deliveryReporter = new DeliveryReporter();
    private final SeenStatusReporter seenStatusReporter = new SeenStatusReporter();
    private final UserDataSynchronizer userDataSynchronizer = new UserDataSynchronizer();
    private final MessageReporter messageReporter = new MessageReporter();
    private final SystemDataReporter systemDataReporter = new SystemDataReporter();
    private final MobileNetworkStateListener mobileNetworkStateListener;
    private final MobileMessagingStats stats;
    private final PlayServicesSupport playServicesSupport = new PlayServicesSupport();
    private final Executor taskExecutor = Executors.newSingleThreadExecutor();
    private ActivityLifecycleMonitor activityLifecycleMonitor;
    private NotificationSettings notificationSettings;
    private MessageStore messageStore;
    private Context context;
    private Geofencing geofencing;
    private SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            if (MobileMessagingProperty.UNREPORTED_USER_DATA.getKey().equals(key) && PreferenceHelper.contains(MobileMessagingCore.this.context, MobileMessagingProperty.UNREPORTED_USER_DATA)) {
                MobileMessagingCore.this.sync();
            }
        }
    };

    protected MobileMessagingCore(Context context) {
        this.context = context;
        this.stats = new MobileMessagingStats(context);
        this.mobileNetworkStateListener = new MobileNetworkStateListener(context);
        this.activityLifecycleMonitor = null;
        this.geofencing = Geofencing.getInstance(context);
        PreferenceHelper.registerOnSharedPreferenceChangeListener(context, this.onSharedPreferenceChangeListener);
    }

    public static MobileMessagingCore getInstance(Context context) {
        if (null != instance) {
            return instance;
        }
        instance = new MobileMessagingCore(context);
        return instance;
    }

    public void sync() {
        this.registrationSynchronizer.syncronize(this.context, this.getDeviceApplicationInstanceId(), this.getRegistrationId(), this.isRegistrationIdReported(), this.getStats(), this.taskExecutor);
        this.deliveryReporter.report(this.context, this.getUnreportedMessageIds(), this.getStats(), this.taskExecutor);
        this.seenStatusReporter.report(this.context, this.getUnreportedSeenMessageIds(), this.getStats(), this.taskExecutor);
        this.userDataSynchronizer.sync(this.context, this.getStats(), this.taskExecutor);
        this.systemDataReporter.report(this.context, this.getStats(), this.taskExecutor);
    }

    public String getRegistrationId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID);
    }

    public void setRegistrationId(String registrationId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID, registrationId);
        this.setRegistrationIdReported(false);
    }

    public String getDeviceApplicationInstanceId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
    }

    public String[] getUnreportedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
    }

    protected void addUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public void removeUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public String[] getUnreportedSeenMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
    }

    protected void addUnreportedSeenMessageIds(String ... messageIDs) {
        String[] seenMessages = this.concatSeenTimestampToMessageIDs(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, seenMessages);
    }

    private String[] concatSeenTimestampToMessageIDs(String[] messageIDs) {
        String[] seenMessages = new String[messageIDs.length];
        if (messageIDs.length > 0) {
            for (int i = 0; i < messageIDs.length; ++i) {
                String messageId = messageIDs[i];
                String seenTimestamp = String.valueOf(System.currentTimeMillis());
                seenMessages[i] = String.format(Locale.getDefault(), "%s, %s", messageId, seenTimestamp);
            }
        }
        return seenMessages;
    }

    public void removeUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    public void setMessagesDelivered(String ... messageIds) {
        this.addUnreportedMessageIds(messageIds);
        this.sync();
    }

    public void setMessagesSeen(String ... messageIds) {
        this.addUnreportedSeenMessageIds(messageIds);
        this.sync();
    }

    public NotificationSettings getNotificationSettings() {
        if (!this.isDisplayNotificationEnabled()) {
            return null;
        }
        if (null != this.notificationSettings) {
            return this.notificationSettings;
        }
        this.notificationSettings = new NotificationSettings(this.context);
        return this.notificationSettings;
    }

    private void setNotificationSettings(NotificationSettings notificationSettings) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED, null != notificationSettings);
        this.notificationSettings = notificationSettings;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    protected static void setGcmSenderId(Context context, String gcmSenderId) {
        if (StringUtils.isBlank(gcmSenderId)) {
            throw new IllegalArgumentException("gcmSenderId is mandatory! Get one here: https://developers.google.com/mobile/add?platform=android&cntapi=gcm");
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.GCM_SENDER_ID, gcmSenderId);
    }

    public String getGcmSenderId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_SENDER_ID);
    }

    public boolean isRegistrationIdReported() {
        return this.registrationSynchronizer.isRegistrationIdReported(this.context);
    }

    private void setRegistrationIdReported(boolean registrationIdReported) {
        this.registrationSynchronizer.setRegistrationIdReported(this.context, registrationIdReported);
    }

    protected static void setMessageStoreClass(Context context, Class<? extends MessageStore> messageStoreClass) {
        String value = null != messageStoreClass ? messageStoreClass.getName() : null;
        PreferenceHelper.saveString(context, MobileMessagingProperty.MESSAGE_STORE_CLASS, value);
    }

    public MessageStore getMessageStore() {
        if (!this.isMessageStoreEnabled()) {
            return null;
        }
        if (null != this.messageStore) {
            return this.messageStore;
        }
        Class<? extends MessageStore> messageStoreClass = null;
        try {
            messageStoreClass = this.getMessageStoreClass();
            this.messageStore = messageStoreClass.newInstance();
            return this.messageStore;
        }
        catch (Exception e) {
            throw new MessageStoreInstantiationException("Can't create message store of type: " + messageStoreClass, e);
        }
    }

    protected Class<? extends MessageStore> getMessageStoreClass() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.MESSAGE_STORE_CLASS);
    }

    public boolean isMessageStoreEnabled() {
        return null != this.getMessageStoreClass();
    }

    protected MobileMessagingStats getStats() {
        return this.stats;
    }

    public void setLastHttpException(Exception lastHttpException) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION, ExceptionUtils.stacktrace(lastHttpException));
    }

    public String getLastHttpException() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION);
    }

    private void setApplicationCode(String applicationCode) {
        if (StringUtils.isBlank(applicationCode)) {
            throw new IllegalArgumentException("applicationCode is mandatory! Get one here: https://portal.infobip.com/push/applications");
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, applicationCode);
    }

    public static String getApplicationCode(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.APPLICATION_CODE);
    }

    protected static void setApiUri(Context context, String apiUri) {
        if (StringUtils.isBlank(apiUri)) {
            throw new IllegalArgumentException("apiUri is mandatory! If in doubt, use " + MobileMessagingProperty.API_URI.getDefaultValue());
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, apiUri);
    }

    public String getApiUri() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.API_URI);
    }

    protected static void setReportCarrierInfo(Context context, boolean reportCarrierInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO, reportCarrierInfo);
    }

    protected static void setReportSystemInfo(Context context, boolean reportSystemInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO, reportSystemInfo);
    }

    private static void cleanup(Context context) {
        String gcmSenderID = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_SENDER_ID);
        String gcmToken = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        Intent intent = new Intent("org.infobip.mobile.messaging.gcm.token.cleanup", null, context, MobileMessagingGcmIntentService.class);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_SENDER_ID", gcmSenderID);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_TOKEN", gcmToken);
        context.startService(intent);
        PreferenceHelper.remove(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, false);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
    }

    static void setGeofencingActivated(Context context, boolean activated) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GEOFENCING_ACTIVATED, activated);
    }

    public static boolean isGeofencingActivated(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.GEOFENCING_ACTIVATED);
    }

    void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (this.geofencing == null) {
            return;
        }
        this.geofencing.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void activateGeofencing() {
        if (this.geofencing == null) {
            return;
        }
        MobileMessagingCore.setGeofencingActivated(this.context, true);
        this.geofencing.activate();
    }

    public void deactivateGeofencing() {
        if (this.geofencing == null) {
            return;
        }
        MobileMessagingCore.setGeofencingActivated(this.context, false);
        this.geofencing.deactivate();
    }

    protected void syncUserData(UserData userData) {
        UserData userDataToReport = new UserData();
        if (userData != null) {
            String existingUserId;
            UserData existingData = this.getUnreportedUserData();
            String userId = userData.getExternalUserId();
            String string = existingUserId = existingData != null ? existingData.getExternalUserId() : null;
            if (!StringUtils.isEqual(userId, existingUserId)) {
                PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_DATA);
                existingData = null;
            }
            userDataToReport = UserData.merge(existingData, userData);
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA, userDataToReport.toString());
    }

    protected UserData getUserData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.USER_DATA)) {
            return new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.USER_DATA));
        }
        return null;
    }

    public UserData getUnreportedUserData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA)) {
            return new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA));
        }
        return null;
    }

    public void setUserDataReportedWithError() {
        this.setUserDataReported(null);
    }

    public void setUserDataReported(UserData userData) {
        if (userData != null) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.USER_DATA, userData.toString());
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
    }

    public void sendMessages(Message ... messages) {
        this.messageReporter.send(this.context, this.getStats(), this.taskExecutor, messages);
    }

    public void readSystemData() {
        boolean reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        SystemData data = new SystemData(SoftwareInformation.getLibraryVersion(), reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", MobileMessagingCore.isGeofencingActivated(this.context));
        Integer hash = PreferenceHelper.findInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        if (hash.intValue() == data.hashCode()) {
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA, data.toString());
    }

    public SystemData getUnreportedSystemData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA)) {
            return new SystemData(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA));
        }
        return null;
    }

    public void setSystemDataReported() {
        SystemData systemData = this.getUnreportedSystemData();
        if (systemData == null) {
            return;
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH, systemData.hashCode());
    }

    public static final class Builder {
        private final Context context;
        private NotificationSettings notificationSettings = null;
        private String applicationCode = null;
        private Geofencing geofencing;

        public Builder(Context context) {
            if (null == context) {
                throw new IllegalArgumentException("context is mandatory!");
            }
            this.context = context;
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withGeofencing(Geofencing geofencing) {
            this.geofencing = geofencing;
            return this;
        }

        private void activateGeofencing() {
            if (this.geofencing != null) {
                this.geofencing.activate();
            }
        }

        public MobileMessagingCore build() {
            if (!this.applicationCode.equals(MobileMessagingCore.getApplicationCode(this.context))) {
                MobileMessagingCore.cleanup(this.context);
            }
            MobileMessagingCore mobileMessagingCore = new MobileMessagingCore(this.context);
            mobileMessagingCore.setNotificationSettings(this.notificationSettings);
            mobileMessagingCore.setApplicationCode(this.applicationCode);
            instance = mobileMessagingCore;
            mobileMessagingCore.activityLifecycleMonitor = new ActivityLifecycleMonitor(this.context);
            mobileMessagingCore.playServicesSupport.checkPlayServices(this.context);
            mobileMessagingCore.readSystemData();
            mobileMessagingCore.activateGeofencing();
            return mobileMessagingCore;
        }
    }
}

