/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.SharedPreferencesMessageStore;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

class MobileMessageHandler {
    public static final int DEFAULT_NOTIFICATION_ID = 0;
    private SharedPreferencesMessageStore messageStore;

    MobileMessageHandler() {
    }

    void handleMessage(Context context, Intent intent) {
        String from = intent.getStringExtra("from");
        Bundle data = intent.getExtras();
        data.putLong("received_timestamp", System.currentTimeMillis());
        Message message = this.createMessage(from, data);
        if (StringUtils.isBlank(message.getMessageId())) {
            Log.w((String)"MobileMessaging", (String)"Ignoring message without messageId");
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Message received from: " + from));
        this.sendDeliveryReport(context, message);
        this.saveMessage(context, message);
        Log.d((String)"MobileMessaging", (String)("Message is silent: " + message.isSilent()));
        if (!message.isSilent()) {
            this.displayNotification(context, message);
        }
        Intent messageReceived = new Intent(Event.MESSAGE_RECEIVED.getKey());
        messageReceived.putExtras(message.getBundle());
        context.sendBroadcast(messageReceived);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messageReceived);
    }

    private void displayNotification(Context context, Message message) {
        NotificationCompat.Builder builder = this.notificationCompatBuilder(context, message);
        if (builder == null) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = builder.build();
        notificationManager.notify(0, notification);
    }

    private void saveMessage(Context context, Message message) {
        if (!MobileMessagingCore.getInstance(context).isMessageStoreEnabled()) {
            Log.d((String)"MobileMessaging", (String)("Skipping save message: " + message.getMessageId()));
            if (message.getGeofenceAreasList() != null && !message.getGeofenceAreasList().isEmpty()) {
                this.messageStore().save(context, message);
                Log.d((String)"MobileMessaging", (String)("Only save message that contains geofence areas: " + message.getMessageId()));
            }
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Saving message: " + message.getMessageId()));
        try {
            MobileMessagingCore.getInstance(context).getMessageStore().save(context, message);
        }
        catch (Exception e) {
            Log.e((String)"MobileMessaging", (String)("Error saving message: " + message.getMessageId()), (Throwable)e);
        }
    }

    private MessageStore messageStore() {
        if (this.messageStore == null) {
            this.messageStore = new SharedPreferencesMessageStore();
        }
        return this.messageStore;
    }

    private Message createMessage(String from, Bundle data) {
        Message message = Message.createFrom(data);
        message.setFrom(from);
        return message;
    }

    private void sendDeliveryReport(Context context, Message message) {
        if (StringUtils.isBlank(message.getMessageId())) {
            Log.e((String)"MobileMessaging", (String)("No ID received for message: " + message));
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Sending DR: " + message.getMessageId()));
        MobileMessagingCore.getInstance(context).setMessagesDelivered(message.getMessageId());
    }

    private NotificationCompat.Builder notificationCompatBuilder(Context context, Message message) {
        NotificationSettings notificationSettings = this.notificationSettings(context, message);
        if (notificationSettings == null) {
            return null;
        }
        Intent intent = new Intent(context, notificationSettings.getCallbackActivity());
        intent.putExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey(), message.getBundle());
        intent.addFlags(notificationSettings.getIntentFlags());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)notificationSettings.getPendingIntentFlags());
        String title = StringUtils.isNotBlank(message.getTitle()) ? message.getTitle() : notificationSettings.getDefaultTitle();
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context).setContentTitle((CharSequence)title).setContentText((CharSequence)message.getBody()).setAutoCancel(notificationSettings.isNotificationAutoCancel()).setContentIntent(pendingIntent).setWhen(message.getReceivedTimestamp().longValue());
        this.setNotificationDefaults(context, notificationBuilder, message);
        this.setNotificationSound(context, notificationBuilder, message);
        this.setNotificationIcon(context, notificationBuilder, message);
        return notificationBuilder;
    }

    private void setNotificationDefaults(Context context, NotificationCompat.Builder notificationBuilder, Message message) {
        NotificationSettings notificationSettings = this.notificationSettings(context, message);
        if (notificationSettings == null) {
            return;
        }
        int notificationDefaults = notificationSettings.getNotificationDefaults();
        if (!message.isDefaultSound()) {
            notificationDefaults &= 0xFFFFFFFE;
        }
        if (!message.isVibrate()) {
            notificationDefaults &= 0xFFFFFFFD;
        }
        notificationBuilder.setDefaults(notificationDefaults);
    }

    private void setNotificationIcon(Context context, NotificationCompat.Builder notificationBuilder, Message message) {
        NotificationSettings notificationSettings = this.notificationSettings(context, message);
        if (notificationSettings == null) {
            return;
        }
        int icon = StringUtils.isNotBlank(message.getIcon()) ? ResourceLoader.loadResourceByName(context, "drawable", message.getIcon()) : notificationSettings.getDefaultIcon();
        notificationBuilder.setSmallIcon(icon);
    }

    private void setNotificationSound(Context context, NotificationCompat.Builder notificationBuilder, Message message) {
        String sound = message.getSound();
        if (!message.isDefaultSound() && StringUtils.isNotBlank(sound)) {
            Uri uri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + sound));
            if (uri != null) {
                notificationBuilder.setSound(uri);
            } else {
                Log.w((String)"MobileMessaging", (String)("Cannot find notification sound: " + sound));
            }
        }
    }

    private NotificationSettings notificationSettings(Context context, Message message) {
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance(context).getNotificationSettings();
        if (null == notificationSettings) {
            return null;
        }
        if (!notificationSettings.isDisplayNotificationEnabled() || null == notificationSettings.getCallbackActivity()) {
            return null;
        }
        if (StringUtils.isBlank(message.getBody())) {
            return null;
        }
        if (ActivityLifecycleMonitor.isForeground() && notificationSettings.isForegroundNotificationDisabled()) {
            return null;
        }
        return notificationSettings;
    }
}

