/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;

public class PlayServicesSupport {
    public static final int DEVICE_NOT_SUPPORTED = -1;
    private static boolean isPlayServicesAvailable;
    private final Handler handler = new Handler();

    public void checkPlayServices(final Context context) {
        GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int errorCode = apiAvailability.isGooglePlayServicesAvailable(context);
        if (errorCode != 0) {
            isPlayServicesAvailable = false;
            if (apiAvailability.isUserResolvableError(errorCode)) {
                Log.e((String)"MobileMessaging", (String)"Error accessing GCM.");
            } else {
                errorCode = -1;
                Log.e((String)"MobileMessaging", (String)"This device is not supported.");
            }
            final int finalErrorCode = errorCode;
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Intent playServicesError = new Intent(Event.GOOGLE_PLAY_SERVICES_ERROR.getKey());
                    playServicesError.putExtra("org.infobip.mobile.messaging.playServices", finalErrorCode);
                    context.sendBroadcast(playServicesError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(playServicesError);
                    PlayServicesSupport.this.handler.removeCallbacksAndMessages(null);
                }
            });
            return;
        }
        isPlayServicesAvailable = true;
        Intent intent = new Intent(context, MobileMessagingGcmIntentService.class);
        context.startService(intent);
    }

    public static boolean isPlayServicesAvailable() {
        return isPlayServicesAvailable;
    }
}

