/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Parcelable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.GeofenceAreas;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;

class GeoAreasHandler {
    protected static final String TAG = "GeofenceTransitions";

    GeoAreasHandler() {
    }

    void handleNotification(Context context, Intent intent) {
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent == null) {
            return;
        }
        if (geofencingEvent.hasError()) {
            String errorMessage = this.getErrorString(geofencingEvent.getErrorCode());
            Log.e((String)TAG, (String)errorMessage);
            return;
        }
        int geofenceTransition = geofencingEvent.getGeofenceTransition();
        List triggeringGeofences = geofencingEvent.getTriggeringGeofences();
        List<GeofenceAreas.Area> areasList = this.getAreasList(context, triggeringGeofences);
        this.LogGeofenceTransition(geofenceTransition);
        this.LogGeofences(areasList);
        if (geofenceTransition == 1) {
            this.displayNotifications(context, areasList);
            Location triggeringLocation = geofencingEvent.getTriggeringLocation();
            GeofenceAreas geofenceAreas = new GeofenceAreas(triggeringLocation.getLatitude(), triggeringLocation.getLongitude(), areasList);
            Intent geofenceAreaEntered = new Intent(Event.GEOFENCE_AREA_ENTERED.getKey());
            geofenceAreaEntered.putExtra("org.infobip.mobile.messaging.message.geofenceAreas", (Parcelable)geofenceAreas);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(geofenceAreaEntered);
            context.sendBroadcast(geofenceAreaEntered);
        }
    }

    private void LogGeofenceTransition(int t) {
        switch (t) {
            case 1: {
                Log.i((String)TAG, (String)"GEOFENCE_TRANSITION_ENTER");
                break;
            }
            case 4: {
                Log.i((String)TAG, (String)"GEOFENCE_TRANSITION_DWELL");
                break;
            }
            case 2: {
                Log.i((String)TAG, (String)"GEOFENCE_TRANSITION_EXIT");
                break;
            }
            default: {
                Log.i((String)TAG, (String)("Transition type is invalid: " + t));
            }
        }
    }

    private void LogGeofences(List<GeofenceAreas.Area> areas) {
        for (GeofenceAreas.Area a : areas) {
            Log.i((String)TAG, (String)("GEOFENCE (" + a.getTitle() + ") LAT:" + a.getLatitude() + " LON:" + a.getLongitude() + " RAD:" + a.getRadius()));
        }
    }

    private String getErrorString(int errorCode) {
        switch (errorCode) {
            case 1000: {
                return "Geofence not available";
            }
            case 1001: {
                return "Too many geofences";
            }
            case 1002: {
                return "Too many pending intents";
            }
        }
        return "Unknown geofence error";
    }

    private void displayNotifications(Context context, List<GeofenceAreas.Area> triggeredGeoAreasList) {
        if (triggeredGeoAreasList == null || triggeredGeoAreasList.isEmpty()) {
            return;
        }
        for (GeofenceAreas.Area area : triggeredGeoAreasList) {
            this.displayNotificationForArea(context, area);
        }
    }

    private List<GeofenceAreas.Area> getAreasList(Context context, List<Geofence> triggeringGeofences) {
        List<Message> messages = MobileMessaging.getInstance(context).getMessageStore().bind(context);
        ArrayList<GeofenceAreas.Area> areasList = new ArrayList<GeofenceAreas.Area>(triggeringGeofences.size());
        for (Message message : messages) {
            List<GeofenceAreas.Area> geoAreasList = message.getGeofenceAreasList();
            if (geoAreasList == null) continue;
            for (GeofenceAreas.Area area : geoAreasList) {
                for (Geofence geofence : triggeringGeofences) {
                    if (!geofence.getRequestId().equalsIgnoreCase(area.getId())) continue;
                    areasList.add(area);
                }
            }
        }
        return areasList;
    }

    private void displayNotificationForArea(Context context, GeofenceAreas.Area area) {
        if (area == null) {
            return;
        }
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance(context).getNotificationSettings();
        if (null == notificationSettings) {
            return;
        }
        if (!notificationSettings.isDisplayNotificationEnabled() || null == notificationSettings.getCallbackActivity()) {
            return;
        }
        Intent intent = new Intent(context, notificationSettings.getCallbackActivity());
        intent.addFlags(notificationSettings.getIntentFlags());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)notificationSettings.getPendingIntentFlags());
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setColor(-65536).setDefaults(notificationSettings.getNotificationDefaults()).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)String.format(Locale.getDefault(), "%s", area.getTitle())).setContentText((CharSequence)String.format(Locale.getDefault(), "Radius: %d m", area.getRadius()));
        int icon = notificationSettings.getDefaultIcon();
        builder.setSmallIcon(icon);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification build = builder.build();
        notificationManager.notify(new Random().nextInt(), build);
    }
}

