/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.reporters;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.api.messages.MoMessageDelivery;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.SendMessageResult;
import org.infobip.mobile.messaging.tasks.SendMessageTask;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageReporter {
    public void send(final Context context, final MobileMessagingStats stats, Executor executor, final Message ... messages) {
        new SendMessageTask(context){

            protected void onPostExecute(SendMessageResult sendMessageResult) {
                if (sendMessageResult.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                    stats.reportError(MobileMessagingError.MESSAGE_SEND_ERROR);
                    Intent sendMessageError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    sendMessageError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)sendMessageResult.getError());
                    context.sendBroadcast(sendMessageError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(sendMessageError);
                    MessageReporter.this.reportFailedMessages(context, sendMessageResult.getError().getMessage(), messages);
                    return;
                }
                ArrayList<Bundle> messageBundles = new ArrayList<Bundle>();
                JsonSerializer serializer = new JsonSerializer();
                for (MoMessageDelivery delivery : sendMessageResult.getMessageDeliveries()) {
                    Message message = MessageDelivery.fromJson(serializer.serialize((Object)delivery));
                    messageBundles.add(message.getBundle());
                }
                Intent messagesSent = new Intent(Event.MESSAGES_SENT.getKey());
                messagesSent.putParcelableArrayListExtra("org.infobip.mobile.messaging.messages", messageBundles);
                context.sendBroadcast(messagesSent);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messagesSent);
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error sending messages!");
                stats.reportError(MobileMessagingError.MESSAGE_SEND_ERROR);
                MessageReporter.this.reportFailedMessages(context, "Network error", messages);
            }
        }.executeOnExecutor(executor, messages);
    }

    private void reportFailedMessages(Context context, String errorMessage, Message ... messages) {
        ArrayList<Bundle> messageBundles = new ArrayList<Bundle>();
        for (Message message : messages) {
            messageBundles.add(message.getBundle());
        }
        Intent messagesSent = new Intent(Event.MESSAGES_SENT.getKey());
        messagesSent.putParcelableArrayListExtra("org.infobip.mobile.messaging.messages", messageBundles);
        context.sendBroadcast(messagesSent);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messagesSent);
    }

    static class MessageDelivery
    extends Message {
        MessageDelivery() {
        }

        public static Message fromJson(String json) {
            JSONObject object;
            try {
                object = new JSONObject(json);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return new Message();
            }
            Bundle bundle = new Bundle();
            bundle.putString(Message.BundleField.DESTINATION.getKey(), object.optString(JsonField.DESTINATION.getKey()));
            bundle.putString(Message.BundleField.MESSAGE_ID.getKey(), object.optString(JsonField.MESSAGE_ID.getKey()));
            bundle.putString(Message.BundleField.BODY.getKey(), object.optString(JsonField.TEXT.getKey()));
            if (object.has(JsonField.CUSTOM_PAYLOAD.getKey())) {
                bundle.putString(Message.BundleField.CUSTOM_PAYLOAD.getKey(), object.optJSONObject(JsonField.CUSTOM_PAYLOAD.getKey()).toString());
            }
            if (object.has(JsonField.STATUS_CODE.getKey())) {
                int statusId = object.optInt(JsonField.STATUS_CODE.getKey(), Message.Status.UNKNOWN.ordinal());
                for (Message.Status status : Message.Status.values()) {
                    if (status.ordinal() != statusId) continue;
                    bundle.putString(Message.BundleField.STATUS.getKey(), status.getKey());
                    break;
                }
            }
            bundle.putString(Message.BundleField.STATUS_MESSAGE.getKey(), object.optString(JsonField.STATUS.getKey()));
            return Message.createFrom(bundle);
        }

        static enum JsonField {
            MESSAGE_ID("messageId"),
            DESTINATION("destination"),
            TEXT("text"),
            CUSTOM_PAYLOAD("customPayload"),
            STATUS_CODE("statusCode"),
            STATUS("status");

            private final String key;

            private JsonField(String key) {
                this.key = key;
            }

            public String getKey() {
                return this.key;
            }
        }
    }
}

