/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.reporters;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.data.SystemDataReport;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.SystemDataReportResult;
import org.infobip.mobile.messaging.tasks.SystemDataReportTask;

public class SystemDataReporter {
    public void report(final Context context, final MobileMessagingStats stats, Executor executor) {
        SystemData data = MobileMessagingCore.getInstance(context).getUnreportedSystemData();
        if (data == null) {
            return;
        }
        SystemDataReport report = new SystemDataReport(data.getSdkVersion(), data.getOsVersion(), data.getDeviceManufacturer(), data.getDeviceModel(), data.getApplicationVersion(), data.getGeofencing());
        new SystemDataReportTask(context){

            protected void onPostExecute(SystemDataReportResult result) {
                if (result.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                    stats.reportError(MobileMessagingError.SYSTEM_DATA_REPORT_ERROR);
                    Intent intent = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    intent.putExtra("org.infobip.mobile.messaging.exception", (Serializable)result.getError());
                    context.sendBroadcast(intent);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                    return;
                }
                if (result.isPostponed()) {
                    Log.w((String)"MobileMessaging", (String)"System data report is saved and will be sent at a later time");
                    return;
                }
                MobileMessagingCore.getInstance(context).setSystemDataReported();
                Intent dataReported = new Intent(Event.SYSTEM_DATA_REPORTED.getKey());
                dataReported.putExtra("org.infobip.mobile.messaging.systemdata", result.getData().toString());
                context.sendBroadcast(dataReported);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(dataReported);
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error reporting user data!");
                stats.reportError(MobileMessagingError.SYSTEM_DATA_REPORT_ERROR);
            }
        }.executeOnExecutor(executor, new SystemDataReport[]{report});
    }
}

