/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.messages.MoMessage;
import org.infobip.mobile.messaging.api.messages.MoMessagesBody;
import org.infobip.mobile.messaging.api.messages.MoMessagesResponse;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;
import org.infobip.mobile.messaging.tasks.SendMessageResult;
import org.infobip.mobile.messaging.util.StringUtils;

public class SendMessageTask
extends AsyncTask<Message, Void, SendMessageResult> {
    private final Context context;

    public SendMessageTask(Context context) {
        this.context = context;
    }

    protected SendMessageResult doInBackground(Message ... messages) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't send messages to MobileMessaging API without valid registration!");
            return new SendMessageResult(new Exception("No valid registration"));
        }
        try {
            MoMessagesBody moMessagesBody = new MoMessagesBody();
            moMessagesBody.setFrom(deviceApplicationInstanceId);
            ArrayList<MoMessage> moMessages = new ArrayList<MoMessage>();
            for (Message message : messages) {
                String customPayloadString = message.getCustomPayload() != null ? message.getCustomPayload().toString() : null;
                Map customPayloadMap = (Map)new JsonSerializer().deserialize(customPayloadString, Map.class);
                moMessages.add(new MoMessage(message.getMessageId(), message.getDestination(), message.getBody(), customPayloadMap));
            }
            moMessagesBody.setMessages(moMessages.toArray(new MoMessage[moMessages.size()]));
            MoMessagesResponse moMessagesResponse = MobileApiResourceProvider.INSTANCE.getMobileApiMessages(this.context).sendMO(moMessagesBody);
            return new SendMessageResult(moMessagesResponse.getMessages());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error sending MO messages!", (Throwable)e);
            this.cancel(true);
            Intent sendMessagesError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            sendMessagesError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(sendMessagesError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(sendMessagesError);
            return new SendMessageResult(e);
        }
    }
}

