/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.DeliveryReportResult;
import org.infobip.mobile.messaging.tasks.DeliveryReportTask;

class DeliveryReporter {
    DeliveryReporter() {
    }

    void report(final Context context, String[] unreportedMessageIds, final MobileMessagingStats stats, Executor executor) {
        if (unreportedMessageIds.length == 0) {
            return;
        }
        new DeliveryReportTask(context){

            protected void onPostExecute(DeliveryReportResult result) {
                if (result.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                    stats.reportError(MobileMessagingError.DELIVERY_REPORTING_ERROR);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)result.getError());
                    context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationSaveError);
                    return;
                }
                Intent messageReceived = new Intent(Event.DELIVERY_REPORTS_SENT.getKey());
                Bundle extras = new Bundle();
                extras.putStringArray("org.infobip.mobile.messaging.message.ids", result.getMessageIDs());
                messageReceived.putExtras(extras);
                context.sendBroadcast(messageReceived);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messageReceived);
            }

            protected void onCancelled() {
                stats.reportError(MobileMessagingError.DELIVERY_REPORTING_ERROR);
                Log.e((String)"MobileMessaging", (String)"Error reporting delivery!");
            }
        }.executeOnExecutor(executor, new Object[0]);
    }
}

