/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.os.Bundle;
import org.infobip.mobile.messaging.Message;
import org.json.JSONException;
import org.json.JSONObject;

public class InternalMessageUtils
extends Message {
    public static String getSilentTitle(Message message) {
        return InternalMessageUtils.getSilentDataField(message, InternalData.TITLE.getKey());
    }

    public static void setSilentTitle(Message message, String title) {
        InternalMessageUtils.setSilentDataField(message, InternalData.TITLE.getKey(), title);
    }

    public static String getSilentBody(Message message) {
        return InternalMessageUtils.getSilentDataField(message, InternalData.BODY.getKey());
    }

    public static void setSilentBody(Message message, String body) {
        InternalMessageUtils.setSilentDataField(message, InternalData.BODY.getKey(), body);
    }

    public static String getSilentSound(Message message) {
        return InternalMessageUtils.getSilentDataField(message, InternalData.SOUND.getKey());
    }

    public static void setSilentSound(Message message, String sound) {
        InternalMessageUtils.setSilentDataField(message, InternalData.SOUND.getKey(), sound);
    }

    private static String getSilentDataField(Message message, String silentKey) {
        JSONObject internalData;
        String internalDataString = message.getBundle().getString(Message.Data.INTERNAL_DATA.getKey());
        if (internalDataString == null) {
            return null;
        }
        try {
            internalData = new JSONObject(internalDataString);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        JSONObject silentData = internalData.optJSONObject(InternalData.SILENT_DATA.getKey());
        if (silentData == null) {
            return null;
        }
        return silentData.optString(silentKey);
    }

    private static void setSilentDataField(Message message, String silentKey, String value) {
        JSONObject silentData;
        Bundle bundle = message.getBundle();
        String internalDataString = message.getBundle().getString(Message.Data.INTERNAL_DATA.getKey());
        JSONObject internalData = null;
        if (internalDataString != null) {
            try {
                internalData = new JSONObject(internalDataString);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (internalData == null) {
            internalData = new JSONObject();
        }
        if ((silentData = internalData.optJSONObject(InternalData.SILENT_DATA.getKey())) == null) {
            silentData = new JSONObject();
        }
        try {
            silentData.put(silentKey, (Object)value);
            internalData.put(InternalData.SILENT_DATA.getKey(), (Object)silentData);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
        bundle.putString(Message.Data.INTERNAL_DATA.getKey(), internalData.toString());
    }

    private static enum InternalData {
        SILENT_DATA("silent"),
        TITLE("title"),
        BODY("body"),
        SOUND("sound");

        private final String key;

        private InternalData(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

