/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.location.Geofence;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GeofenceAreas
implements Parcelable {
    @SerializedName(value="triggeringLatitude")
    private Double triggeringLatitude;
    @SerializedName(value="triggeringLongitude")
    private Double triggeringLongitude;
    @SerializedName(value="geo")
    private List<Area> areasList = new ArrayList<Area>();
    public static final Parcelable.Creator<GeofenceAreas> CREATOR = new Parcelable.Creator<GeofenceAreas>(){

        public GeofenceAreas createFromParcel(Parcel in) {
            return new GeofenceAreas(in);
        }

        public GeofenceAreas[] newArray(int size) {
            return new GeofenceAreas[size];
        }
    };

    public GeofenceAreas(Double triggeringLatitude, Double triggeringLongitude, List<Area> areasList) {
        this.triggeringLatitude = triggeringLatitude;
        this.triggeringLongitude = triggeringLongitude;
        this.areasList = areasList;
    }

    protected GeofenceAreas(Parcel in) {
        this.triggeringLatitude = in.readDouble();
        this.triggeringLongitude = in.readDouble();
        in.readTypedList(this.areasList, Area.CREATOR);
    }

    public Double getTriggeringLatitude() {
        return this.triggeringLatitude;
    }

    public Double getTriggeringLongitude() {
        return this.triggeringLongitude;
    }

    public List<Area> getAreasList() {
        return this.areasList;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeDouble(this.triggeringLatitude.doubleValue());
        parcel.writeDouble(this.triggeringLongitude.doubleValue());
        parcel.writeTypedList(this.areasList);
    }

    public static class Area
    implements Parcelable {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="title")
        private String title;
        @SerializedName(value="latitude")
        private Double latitude;
        @SerializedName(value="longitude")
        private Double longitude;
        @SerializedName(value="radiusInMeters")
        private Integer radius;
        @SerializedName(value="expiry")
        private Long expiry;
        public static final Parcelable.Creator<Area> CREATOR = new Parcelable.Creator<Area>(){

            public Area createFromParcel(Parcel in) {
                return new Area(in);
            }

            public Area[] newArray(int size) {
                return new Area[size];
            }
        };

        public Area(String id, String title, Double latitude, Double longitude, Integer radius, Long expiry) {
            this.id = id;
            this.title = title;
            this.latitude = latitude;
            this.longitude = longitude;
            this.radius = radius;
            this.expiry = expiry;
        }

        protected Area(Parcel in) {
            this.id = in.readString();
            this.title = in.readString();
            this.latitude = in.readDouble();
            this.longitude = in.readDouble();
            this.radius = in.readInt();
            this.expiry = in.readLong();
        }

        public Long getExpiry() {
            return this.expiry == 0L ? TimeUnit.HOURS.toMillis(24L) : this.expiry.longValue();
        }

        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public Integer getRadius() {
            return this.radius;
        }

        public Geofence toGeofence() {
            return new Geofence.Builder().setCircularRegion(this.getLatitude().doubleValue(), this.getLongitude().doubleValue(), (float)this.getRadius().intValue()).setExpirationDuration(this.getExpiry().longValue()).setRequestId(this.getId()).setTransitionTypes(1).build();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeString(this.id);
            parcel.writeString(this.title);
            parcel.writeDouble(this.latitude.doubleValue());
            parcel.writeDouble(this.longitude.doubleValue());
            parcel.writeInt(this.radius.intValue());
            parcel.writeLong(this.expiry.longValue());
        }
    }
}

