/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import org.infobip.mobile.messaging.Geofencing;
import org.infobip.mobile.messaging.MoMessage;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=11)
public class MobileMessaging {
    public static final String TAG = "MobileMessaging";
    private static MobileMessaging instance;
    private final Context context;
    private OnReplyClickListener replyClickListener;

    private MobileMessaging(Context context) {
        this.context = context;
    }

    public static synchronized MobileMessaging getInstance(Context context) {
        if (null != instance) {
            return instance;
        }
        instance = new MobileMessaging(context);
        return instance;
    }

    public void setMessagesDelivered(String ... messageIds) {
        MobileMessagingCore.getInstance(this.context).setMessagesDelivered(messageIds);
    }

    public void setMessagesSeen(String ... messageIds) {
        MobileMessagingCore.getInstance(this.context).setMessagesSeen(messageIds);
    }

    public MessageStore getMessageStore() {
        return MobileMessagingCore.getInstance(this.context).getMessageStore();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        MobileMessagingCore.getInstance(this.context).onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void setUserData(String externalUserId, UserData userData) {
        MobileMessagingCore.getInstance(this.context).setUserData(externalUserId, userData);
    }

    public UserData getUserData() {
        return MobileMessagingCore.getInstance(this.context).getUserData();
    }

    public void sendMessages(MoMessage ... messages) {
        MobileMessagingCore.getInstance(this.context).sendMessages(messages);
    }

    public void activateGeofencing() {
        MobileMessagingCore.getInstance(this.context).activateGeofencing();
    }

    public void deactivateGeofencing() {
        MobileMessagingCore.getInstance(this.context).deactivateGeofencing();
    }

    public static final class Builder {
        private Geofencing geofencing;
        private final Context context;
        private String gcmSenderId = (String)MobileMessagingProperty.GCM_SENDER_ID.getDefaultValue();
        private String applicationCode = (String)MobileMessagingProperty.APPLICATION_CODE.getDefaultValue();
        private String apiUri = (String)MobileMessagingProperty.API_URI.getDefaultValue();
        private NotificationSettings notificationSettings = null;
        private boolean reportCarrierInfo = true;
        private boolean reportSystemInfo = true;
        private Class<? extends MessageStore> messageStoreClass = (Class)MobileMessagingProperty.MESSAGE_STORE_CLASS.getDefaultValue();
        private OnReplyClickListener replyActionClickListener;

        public Builder(Context context) {
            if (null == context) {
                throw new IllegalArgumentException("context object is mandatory!");
            }
            this.context = context;
            this.geofencing = Geofencing.getInstance(context);
            this.loadDefaultApiUri(context);
            this.loadGcmSenderId(context);
            this.loadApplicationCode(context);
            this.loadNotificationSettings(context);
        }

        private void loadNotificationSettings(Context context) {
            boolean displayNotificationEnabled = (Boolean)MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED.getDefaultValue();
            if (!displayNotificationEnabled) {
                return;
            }
            this.notificationSettings = new NotificationSettings.Builder(context).build();
        }

        private void loadDefaultApiUri(Context context) {
            String apiUri;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_api_uri");
            if (resource > 0 && StringUtils.isNotBlank(apiUri = context.getResources().getString(resource))) {
                this.apiUri = apiUri;
            }
        }

        private void loadGcmSenderId(Context context) {
            String gcmSenderId;
            int resource = ResourceLoader.loadResourceByName(context, "string", "google_app_id");
            if (resource > 0 && StringUtils.isNotBlank(gcmSenderId = context.getResources().getString(resource))) {
                this.gcmSenderId = gcmSenderId;
            }
        }

        private void loadApplicationCode(Context context) {
            String applicationCode;
            int resource = ResourceLoader.loadResourceByName(context, "string", "infobip_application_code");
            if (resource > 0 && StringUtils.isNotBlank(applicationCode = context.getResources().getString(resource))) {
                this.applicationCode = applicationCode;
            }
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withGcmSenderId(String gcmSenderId) {
            this.validateWithParam(gcmSenderId);
            this.gcmSenderId = gcmSenderId;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withApiUri(String apiUri) {
            this.validateWithParam(apiUri);
            this.apiUri = apiUri;
            return this;
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.validateWithParam(notificationSettings);
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withoutDisplayNotification() {
            this.notificationSettings = null;
            return this;
        }

        public Builder withMessageStore(Class<? extends MessageStore> messageStoreClass) {
            this.validateWithParam(messageStoreClass);
            this.messageStoreClass = messageStoreClass;
            return this;
        }

        public Builder withoutGeofencing() {
            this.geofencing = null;
            return this;
        }

        public Builder withoutMessageStore() {
            this.messageStoreClass = null;
            return this;
        }

        public Builder withoutCarrierInfo() {
            this.reportCarrierInfo = false;
            return this;
        }

        public Builder withoutSystemInfo() {
            this.reportSystemInfo = false;
            return this;
        }

        public Builder withOnReplyClickListener(OnReplyClickListener replyActionClickListener) {
            this.replyActionClickListener = replyActionClickListener;
            return this;
        }

        public MobileMessaging build() {
            MobileMessagingCore.setApiUri(this.context, this.apiUri);
            MobileMessagingCore.setGcmSenderId(this.context, this.gcmSenderId);
            MobileMessagingCore.setMessageStoreClass(this.context, this.messageStoreClass);
            MobileMessagingCore.setReportCarrierInfo(this.context, this.reportCarrierInfo);
            MobileMessagingCore.setReportSystemInfo(this.context, this.reportSystemInfo);
            MobileMessaging mobileMessaging = new MobileMessaging(this.context);
            instance = mobileMessaging;
            new MobileMessagingCore.Builder(this.context).withOnReplyClickListener(this.replyActionClickListener).withDisplayNotification(this.notificationSettings).withApplicationCode(this.applicationCode).withGeofencing(this.geofencing).build();
            return mobileMessaging;
        }
    }

    public static interface OnReplyClickListener {
        public void onReplyClicked(Intent var1);
    }
}

