/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.api.shaded.google.gson.Gson;
import org.infobip.mobile.messaging.api.shaded.google.gson.GsonBuilder;

public class UserData {
    private Map<String, Object> predefinedUserData;
    private Map<String, Object> customUserData;

    public UserData() {
        this.predefinedUserData = new HashMap<String, Object>();
        this.customUserData = new HashMap<String, Object>();
    }

    public UserData(String userData) {
        Gson gson = new Gson();
        UserData data = (UserData)gson.fromJson(userData, UserData.class);
        this.predefinedUserData = data.predefinedUserData;
        this.customUserData = data.customUserData;
    }

    public UserData(Map<String, Object> predefinedUserData, Map<String, Object> customUserData) {
        this.predefinedUserData = predefinedUserData;
        this.customUserData = customUserData;
    }

    public static UserData merge(UserData old, UserData latest) {
        UserData merged = new UserData();
        merged.add(old);
        merged.add(latest);
        return merged;
    }

    private void add(UserData data) {
        if (data == null) {
            return;
        }
        if (data.predefinedUserData != null) {
            this.predefinedUserData.putAll(data.predefinedUserData);
        }
        if (data.customUserData != null) {
            this.customUserData.putAll(data.customUserData);
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    public Map<String, Object> getPredefinedUserData() {
        return this.predefinedUserData;
    }

    public void setPredefinedUserData(Map<String, Object> predefinedUserData) {
        this.predefinedUserData = this.customUserData;
    }

    public Map<String, Object> getCustomUserData() {
        return this.customUserData;
    }

    public void setCustomUserData(Map<String, Object> customUserData) {
        this.customUserData = customUserData;
    }

    public String getMsisdn() {
        return (String)this.getField(PredefinedField.MSISDN);
    }

    public void setMsisdn(String msisdn) {
        this.setField(PredefinedField.MSISDN, msisdn);
    }

    public String getFirstName() {
        return (String)this.getField(PredefinedField.FIRST_NAME);
    }

    public void setFirstName(String firstName) {
        this.setField(PredefinedField.FIRST_NAME, firstName);
    }

    public String getLastName() {
        return (String)this.getField(PredefinedField.LAST_NAME);
    }

    public void setLastName(String lastName) {
        this.setField(PredefinedField.LAST_NAME, lastName);
    }

    public String getGender() {
        return (String)this.getField(PredefinedField.GENDER);
    }

    public void setGender(String gender) {
        this.setField(PredefinedField.GENDER, gender);
    }

    public String getBirthdate() {
        return (String)this.getField(PredefinedField.BIRTHDATE);
    }

    public void setBirthdate(String birthdate) {
        this.setField(PredefinedField.BIRTHDATE, birthdate);
    }

    public String getEmail() {
        return (String)this.getField(PredefinedField.EMAIL);
    }

    public void setEmail(String email) {
        this.setField(PredefinedField.EMAIL, email);
    }

    private <T> T getField(PredefinedField field) {
        if (this.predefinedUserData == null) {
            return null;
        }
        Object object = this.predefinedUserData.get(field.getKey());
        try {
            return (T)object;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void setField(PredefinedField field, Object value) {
        this.predefinedUserData.put(field.getKey(), value);
    }

    protected static enum PredefinedField {
        MSISDN("msisdn"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        GENDER("gender"),
        BIRTHDATE("birthdate"),
        EMAIL("email");

        private final String key;

        private PredefinedField(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

