/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.reporters;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.tasks.UpsertRegistrationResult;
import org.infobip.mobile.messaging.tasks.UpsertRegistrationTask;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.StringUtils;

public class RegistrationSynchronizer {
    public void syncronize(Context context, String deviceApplicationInstanceId, String registrationId, boolean registrationIdSaved, MobileMessagingStats stats, Executor executor) {
        if (null != deviceApplicationInstanceId && registrationIdSaved) {
            return;
        }
        this.reportRegistration(context, registrationId, stats, executor);
    }

    private void reportRegistration(final Context context, final String registrationId, final MobileMessagingStats stats, Executor executor) {
        if (StringUtils.isBlank(registrationId)) {
            return;
        }
        new UpsertRegistrationTask(context){

            protected void onPostExecute(UpsertRegistrationResult result) {
                if (result.hasError() || StringUtils.isBlank(result.getDeviceInstanceId())) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error!");
                    stats.reportError(MobileMessagingError.REGISTRATION_SYNC_ERROR);
                    Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)result.getError());
                    context.sendBroadcast(registrationSaveError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationSaveError);
                    return;
                }
                RegistrationSynchronizer.this.setDeviceApplicationInstanceId(context, result.getDeviceInstanceId());
                RegistrationSynchronizer.this.setRegistrationIdReported(context, true);
                Intent registrationCreated = new Intent(Event.REGISTRATION_CREATED.getKey());
                registrationCreated.putExtra("org.infobip.mobile.messaging.gcm.token", registrationId);
                registrationCreated.putExtra("org.infobip.mobile.messaging.infobip.token", result.getDeviceInstanceId());
                context.sendBroadcast(registrationCreated);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(registrationCreated);
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error creating registration!");
                RegistrationSynchronizer.this.setRegistrationIdReported(context, false);
                stats.reportError(MobileMessagingError.REGISTRATION_SYNC_ERROR);
            }
        }.executeOnExecutor(executor, new Object[0]);
    }

    private void setDeviceApplicationInstanceId(Context context, String registrationId) {
        PreferenceHelper.saveString(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID, registrationId);
    }

    public void setRegistrationIdReported(Context context, boolean registrationIdSaved) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, registrationIdSaved);
    }

    public boolean isRegistrationIdReported(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED);
    }
}

