/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.deliveryreports.DeliveryReport;
import org.infobip.mobile.messaging.tasks.DeliveryReportResult;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
public class DeliveryReportTask
extends AsyncTask<Object, Void, DeliveryReportResult> {
    private final Context context;

    public DeliveryReportTask(Context context) {
        this.context = context;
    }

    protected DeliveryReportResult doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't report delivery reports to MobileMessaging API without valid registration!");
            return null;
        }
        try {
            String[] messageIDs = mobileMessagingCore.getUnreportedMessageIds();
            MobileApiResourceProvider.INSTANCE.getMobileApiDeliveryReport(this.context).report(new DeliveryReport(messageIDs));
            mobileMessagingCore.removeUnreportedMessageIds(messageIDs);
            return new DeliveryReportResult(messageIDs);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error reporting delivery!", (Throwable)e);
            this.cancel(true);
            Intent registrationSaveError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            registrationSaveError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(registrationSaveError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(registrationSaveError);
            return new DeliveryReportResult(e);
        }
    }
}

