/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.tasks;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.api.userdata.UserDataReport;
import org.infobip.mobile.messaging.tasks.MobileApiResourceProvider;
import org.infobip.mobile.messaging.tasks.SyncUserDataResult;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
public class SyncUserDataTask
extends AsyncTask<Void, Void, SyncUserDataResult> {
    private final Context context;

    public SyncUserDataTask(Context context) {
        this.context = context;
    }

    protected SyncUserDataResult doInBackground(Void ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't sync user data without valid registration!");
            return new SyncUserDataResult(new Exception("Syncing user data: no valid registration"));
        }
        String externalUserId = mobileMessagingCore.getExternalUserId();
        if (StringUtils.isBlank(externalUserId)) {
            Log.e((String)"MobileMessaging", (String)"Can't sync user data without valid external user Id!");
            return new SyncUserDataResult(new Exception("Syncing user data: no valid external user id"));
        }
        UserData userData = mobileMessagingCore.getUnreportedUserData();
        try {
            UserDataReport request = new UserDataReport(userData.getPredefinedUserData(), userData.getCustomUserData());
            UserDataReport response = MobileApiResourceProvider.INSTANCE.getMobileApiUserDataSync(this.context).sync(deviceApplicationInstanceId, externalUserId, request);
            return new SyncUserDataResult(response.getPredefinedUserData(), response.getCustomUserData());
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error synchronizing user data!", (Throwable)e);
            this.cancel(true);
            Intent userDataSyncError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            userDataSyncError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(userDataSyncError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(userDataSyncError);
            return new SyncUserDataResult(e);
        }
    }
}

