/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.support.Tuple;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.ConfigurationException;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeofenceTransitionsIntentService;
import org.infobip.mobile.messaging.geo.GeofencingAlarmReceiver;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.SharedPreferencesMessageStore;

public class Geofencing
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private static String TAG = "Geofencing";
    private static Context context;
    private static Geofencing instance;
    private GoogleApiClient googleApiClient;
    private List<Geofence> geofences;
    private PendingIntent geofencePendingIntent;
    private MessageStore messageStore;

    private Geofencing(Context context) {
        this.checkRequiredService(context, GeofenceTransitionsIntentService.class);
        Geofencing.context = context;
        this.geofences = new ArrayList<Geofence>();
        this.messageStore = new SharedPreferencesMessageStore();
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    public static Geofencing getInstance(Context context) {
        if (instance != null) {
            return instance;
        }
        instance = new Geofencing(context);
        return instance;
    }

    public static void scheduleRefresh(Context context) {
        Geofencing.scheduleRefresh(context, new Date());
    }

    public static void scheduleRefresh(Context context, Date when) {
        Log.i((String)TAG, (String)("Next refresh in: " + when));
        if (when == null) {
            return;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        alarmManager.set(0, when.getTime(), PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(context, GeofencingAlarmReceiver.class), (int)0));
    }

    private static Tuple<List<Geofence>, Date> calculateGeofencesToMonitorAndNextCheckDate(MessageStore messageStore) {
        Date nextCheckDate = null;
        Date now = new Date();
        HashMap<String, Geofence> geofences = new HashMap<String, Geofence>();
        HashMap<String, Date> expiryDates = new HashMap<String, Date>();
        List<Message> messages = messageStore.bind(context);
        for (Message message : messages) {
            Geo geo = message.getGeo();
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty() || !geo.isEligibleForMonitoring()) continue;
            List<Area> geoAreasList = message.getGeo().getAreasList();
            for (Area area : geoAreasList) {
                Date expiry;
                if (!area.isValid() || (expiry = (Date)expiryDates.get(area.getId())) != null && expiry.after(geo.getExpiryDate())) continue;
                expiryDates.put(area.getId(), geo.getExpiryDate());
                geofences.put(area.getId(), area.toGeofence(geo.getExpiryDate()));
            }
            Date startDate = geo.getStartDate();
            Date expiryDate = geo.getExpiryDate();
            if (nextCheckDate == null) {
                nextCheckDate = startDate;
                continue;
            }
            if (startDate == null || !startDate.before(nextCheckDate) || expiryDate == null || !expiryDate.after(now)) continue;
            nextCheckDate = startDate;
        }
        ArrayList geofenceList = new ArrayList(geofences.values());
        return new Tuple(geofenceList, nextCheckDate);
    }

    public void activate() {
        if (!PlayServicesSupport.isPlayServicesAvailable(context) || !MobileMessagingCore.isGeofencingActivated(context)) {
            return;
        }
        if (!this.checkRequiredPermissions()) {
            return;
        }
        Tuple<List<Geofence>, Date> tuple = Geofencing.calculateGeofencesToMonitorAndNextCheckDate(this.messageStore);
        Geofencing.scheduleRefresh(context, (Date)tuple.getRight());
        this.geofences = (List)tuple.getLeft();
        if (this.geofences.isEmpty()) {
            return;
        }
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.addGeofences(this.googleApiClient, this.geofencingRequest(), this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                MobileMessagingCore.setGeofencingActivated(context, status.isSuccess());
                Geofencing.this.logGeofenceStatus(status, true);
            }
        });
    }

    public void deactivate() {
        if (!this.checkRequiredPermissions()) {
            return;
        }
        if (!this.googleApiClient.isConnected()) {
            this.googleApiClient.connect();
            return;
        }
        LocationServices.GeofencingApi.removeGeofences(this.googleApiClient, this.geofencePendingIntent()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void onResult(@NonNull Status status) {
                MobileMessagingCore.setGeofencingActivated(context, !status.isSuccess());
                Geofencing.this.logGeofenceStatus(status, false);
            }
        });
    }

    private boolean checkRequiredPermissions() {
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            Log.e((String)"MobileMessaging", (String)"Unable to initialize geofencing. Please, add the following permission to the AndroidManifest.xml: android.permission.ACCESS_FINE_LOCATION");
            return false;
        }
        return true;
    }

    private void checkRequiredService(Context context, Class serviceClass) {
        String serviceName = serviceClass.getCanonicalName();
        ComponentName componentName = new ComponentName(context.getPackageName(), serviceName);
        try {
            context.getPackageManager().getServiceInfo(componentName, 128);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            throw new ConfigurationException(String.format(ConfigurationException.Reason.MISSING_REQUIRED_SERVICE.message(), serviceName));
        }
    }

    private void logGeofenceStatus(@NonNull Status status, boolean activated) {
        if (status.isSuccess()) {
            Log.d((String)TAG, (String)("Geofencing monitoring " + (activated ? "" : "de-") + "activated successfully"));
        } else {
            Log.e((String)TAG, (String)("Geofencing monitoring " + (activated ? "" : "de-") + "activation failed"), (Throwable)new Throwable(status.getStatusMessage()));
        }
    }

    private GeofencingRequest geofencingRequest() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(this.geofences);
        return builder.build();
    }

    private PendingIntent geofencePendingIntent() {
        if (this.geofencePendingIntent == null) {
            Intent intent = new Intent(context, GeofenceTransitionsIntentService.class);
            this.geofencePendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        }
        return this.geofencePendingIntent;
    }

    public void onConnected(@Nullable Bundle bundle) {
        Log.d((String)TAG, (String)"GoogleApiClient connected");
        this.activate();
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Log.e((String)TAG, (String)connectionResult.getErrorMessage(), (Throwable)new ConfigurationException(ConfigurationException.Reason.CHECK_LOCATION_SETTINGS));
    }
}

