/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.util.List;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.gcm.MobileMessageHandler;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesResult;
import org.infobip.mobile.messaging.mobile.messages.SyncMessagesTask;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;

public class MessagesSynchronizer {
    public void synchronize(Context context, MobileMessagingStats stats, Executor executor) {
        this.syncMessages(context, stats, executor);
    }

    private void syncMessages(final Context context, final MobileMessagingStats stats, Executor executor) {
        new SyncMessagesTask(context){

            protected void onPostExecute(SyncMessagesResult syncMessagesResult) {
                if (syncMessagesResult.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error (synchronizing messages)!");
                    stats.reportError(MobileMessagingError.SYNC_MESSAGES_ERROR);
                    return;
                }
                MobileMessageHandler messageHandler = new MobileMessageHandler();
                List<Message> messages = syncMessagesResult.getMessages();
                if (messages == null) {
                    return;
                }
                for (Message message : messages) {
                    Intent intent = new Intent();
                    intent.putExtras(message.getBundle());
                    messageHandler.handleMessage(context, intent);
                }
            }

            protected void onCancelled() {
                Log.e((String)"MobileMessaging", (String)"Error syncing messages!");
                stats.reportError(MobileMessagingError.SYNC_MESSAGES_ERROR);
            }
        }.executeOnExecutor(executor, new Object[0]);
    }
}

