/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.seen;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.messages.SeenMessages;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.seen.SeenMessagesReport;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReportResult;
import org.infobip.mobile.messaging.util.StringUtils;

@TargetApi(value=14)
class SeenStatusReportTask
extends AsyncTask<Object, Void, SeenStatusReportResult> {
    private final Context context;

    SeenStatusReportTask(Context context) {
        this.context = context;
    }

    protected SeenStatusReportResult doInBackground(Object ... notUsed) {
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.e((String)"MobileMessaging", (String)"Can't send seen reports to MobileMessaging API without valid registration!");
            return new SeenStatusReportResult(new Exception("No valid registration"));
        }
        try {
            String[] messageIDs = mobileMessagingCore.getUnreportedSeenMessageIds();
            SeenMessages seenMessages = SeenMessagesReport.fromMessageIds(messageIDs);
            MobileApiResourceProvider.INSTANCE.getMobileApiMessages(this.context).reportSeen(seenMessages);
            mobileMessagingCore.removeUnreportedSeenMessageIds(messageIDs);
            return new SeenStatusReportResult(messageIDs);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error reporting seen status!", (Throwable)e);
            this.cancel(true);
            Intent seenStatusReportError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            seenStatusReportError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(seenStatusReportError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(seenStatusReportError);
            return new SeenStatusReportResult(e);
        }
    }
}

