/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.telephony.TelephonyManager;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileNetworkInformation {
    private MobileNetworkInformation() {
    }

    public static String getMobileCarrierName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getNetworkOperatorName();
        }
        return "unknown";
    }

    public static String getMobileCoutryCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return MobileNetworkInformation.extractMCC(telephonyManager.getNetworkOperator());
        }
        return "unknown";
    }

    public static String getMobileNetworkCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return MobileNetworkInformation.extractMNC(telephonyManager.getNetworkOperator());
        }
        return "unknown";
    }

    public static String getSIMCarrierName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return telephonyManager.getSimOperatorName();
        }
        return "unknown";
    }

    public static String getSIMCoutryCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return MobileNetworkInformation.extractMCC(telephonyManager.getSimOperator());
        }
        return "unknown";
    }

    public static String getSIMNetworkCode(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            return MobileNetworkInformation.extractMNC(telephonyManager.getSimOperator());
        }
        return "unknown";
    }

    private static String extractMCC(String operator) {
        if (StringUtils.isNotBlank(operator)) {
            return operator.substring(0, 3);
        }
        return "unknown";
    }

    private static String extractMNC(String operator) {
        if (StringUtils.isNotBlank(operator)) {
            return operator.substring(3);
        }
        return "unknown";
    }
}

