/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageStoreInstantiationException;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.gcm.MobileMessagingGcmIntentService;
import org.infobip.mobile.messaging.gcm.PlayServicesSupport;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.geo.Geofencing;
import org.infobip.mobile.messaging.mobile.data.SystemDataReporter;
import org.infobip.mobile.messaging.mobile.data.UserDataSynchronizer;
import org.infobip.mobile.messaging.mobile.geo.GeoReporter;
import org.infobip.mobile.messaging.mobile.messages.MessageSender;
import org.infobip.mobile.messaging.mobile.messages.MessagesSynchronizer;
import org.infobip.mobile.messaging.mobile.registration.RegistrationSynchronizer;
import org.infobip.mobile.messaging.mobile.seen.SeenStatusReporter;
import org.infobip.mobile.messaging.mobile.version.VersionChecker;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.telephony.MobileNetworkStateListener;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.ExceptionUtils;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.infobip.mobile.messaging.util.SystemInformation;

public class MobileMessagingCore {
    private static final int MESSAGE_ID_PARAMETER_LIMIT = 100;
    private static final long MESSAGE_EXPIRY_TIME = TimeUnit.DAYS.toMillis(7L);
    private static MobileMessagingCore instance;
    private final RegistrationSynchronizer registrationSynchronizer = new RegistrationSynchronizer();
    private final MessagesSynchronizer messagesSynchronizer = new MessagesSynchronizer();
    private final SeenStatusReporter seenStatusReporter = new SeenStatusReporter();
    private final UserDataSynchronizer userDataSynchronizer = new UserDataSynchronizer();
    private final MessageSender messageSender = new MessageSender();
    private final SystemDataReporter systemDataReporter = new SystemDataReporter();
    private final VersionChecker versionChecker = new VersionChecker();
    private final GeoReporter geoReporter = new GeoReporter();
    private final MobileMessagingStats stats;
    private final Executor taskExecutor = Executors.newSingleThreadExecutor();
    private ActivityLifecycleMonitor activityLifecycleMonitor;
    private MobileNetworkStateListener mobileNetworkStateListener;
    private PlayServicesSupport playServicesSupport;
    private NotificationSettings notificationSettings;
    private MessageStore messageStore;
    private Context context;
    private Geofencing geofencing;

    protected MobileMessagingCore(Context context) {
        this.context = context;
        this.stats = new MobileMessagingStats(context);
    }

    public static MobileMessagingCore getInstance(Context context) {
        if (null != instance) {
            return instance;
        }
        return new MobileMessagingCore(context);
    }

    public void sync() {
        this.registrationSynchronizer.synchronize(this.context, this.getDeviceApplicationInstanceId(), this.getRegistrationId(), this.isRegistrationIdReported(), this.getStats(), this.taskExecutor);
        this.messagesSynchronizer.synchronize(this.context, this.getStats(), this.taskExecutor);
        this.userDataSynchronizer.sync(this.context, this.getStats(), this.taskExecutor, null);
        this.seenStatusReporter.report(this.context, this.getUnreportedSeenMessageIds(), this.getStats(), this.taskExecutor);
        this.systemDataReporter.report(this.context, this.getStats(), this.taskExecutor);
        this.versionChecker.check(this.context);
        this.geoReporter.report(this.context, this.getStats());
    }

    public String getRegistrationId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID);
    }

    public void setRegistrationId(String registrationId) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.GCM_REGISTRATION_ID, registrationId);
        this.setRegistrationIdReported(false);
    }

    public String getDeviceApplicationInstanceId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
    }

    public String[] getUnreportedMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
    }

    private void addUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public void addSyncMessagesIds(String ... messageIDs) {
        String[] timestampMessageIdPair = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, timestampMessageIdPair);
    }

    public String[] getSyncMessagesIds() {
        String[] messageIds = PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
        ArrayList<String> messageIdsArrayList = new ArrayList<String>(Arrays.asList(messageIds));
        String[] messageIdsToSync = new String[messageIdsArrayList.size() <= 100 ? messageIdsArrayList.size() : 100];
        boolean shouldUpdateMessageIds = false;
        for (int i = 0; i < messageIdsArrayList.size(); ++i) {
            String syncMessage = messageIdsArrayList.get(i);
            String[] messageIdWithTimestamp = syncMessage.split(", ");
            String strTimeMessageReceived = messageIdWithTimestamp[1];
            long timeMessageReceived = Long.valueOf(strTimeMessageReceived);
            long timeInterval = System.currentTimeMillis() - timeMessageReceived;
            if (timeInterval > MESSAGE_EXPIRY_TIME || i >= 100) {
                messageIdsArrayList.remove(i);
                shouldUpdateMessageIds = true;
                continue;
            }
            messageIdsToSync[i] = messageIdWithTimestamp[0];
        }
        if (shouldUpdateMessageIds) {
            String[] messageIdsToUpdate = new String[messageIdsArrayList.size()];
            messageIdsToUpdate = messageIdsArrayList.toArray(messageIdsToUpdate);
            PreferenceHelper.remove(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS);
            PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_SYNC_MESSAGES_IDS, messageIdsToUpdate);
        }
        return messageIdsToSync;
    }

    public void removeUnreportedMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS, messageIDs);
    }

    public String[] getUnreportedSeenMessageIds() {
        return PreferenceHelper.findStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
    }

    private void addUnreportedSeenMessageIds(String ... messageIDs) {
        String[] seenMessages = this.concatTimestampToMessageId(messageIDs);
        PreferenceHelper.appendToStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, seenMessages);
    }

    private String[] concatTimestampToMessageId(String[] messageIDs) {
        String[] syncMessages = new String[messageIDs.length];
        if (messageIDs.length > 0) {
            for (int i = 0; i < messageIDs.length; ++i) {
                String messageId = messageIDs[i];
                String seenTimestamp = String.valueOf(System.currentTimeMillis());
                syncMessages[i] = StringUtils.concat(messageId, seenTimestamp, ", ");
            }
        }
        return syncMessages;
    }

    public void removeUnreportedSeenMessageIds(String ... messageIDs) {
        PreferenceHelper.deleteFromStringArray(this.context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS, messageIDs);
    }

    public void setMessagesDelivered(String ... messageIds) {
        this.addUnreportedMessageIds(messageIds);
        this.addSyncMessagesIds(messageIds);
        this.sync();
    }

    void setMessagesSeen(String ... messageIds) {
        this.addUnreportedSeenMessageIds(messageIds);
        this.sync();
    }

    public NotificationSettings getNotificationSettings() {
        if (!this.isDisplayNotificationEnabled()) {
            return null;
        }
        if (null != this.notificationSettings) {
            return this.notificationSettings;
        }
        this.notificationSettings = new NotificationSettings(this.context);
        return this.notificationSettings;
    }

    private void setNotificationSettings(NotificationSettings notificationSettings) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED, null != notificationSettings);
        this.notificationSettings = notificationSettings;
    }

    private boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    static void setGcmSenderId(Context context, String gcmSenderId) {
        if (StringUtils.isBlank(gcmSenderId)) {
            throw new IllegalArgumentException("gcmSenderId is mandatory! Get one here: https://developers.google.com/mobile/add?platform=android&cntapi=gcm");
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.GCM_SENDER_ID, gcmSenderId);
    }

    public String getGcmSenderId() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.GCM_SENDER_ID);
    }

    public boolean isRegistrationIdReported() {
        return this.registrationSynchronizer.isRegistrationIdReported(this.context);
    }

    private void setRegistrationIdReported(boolean registrationIdReported) {
        this.registrationSynchronizer.setRegistrationIdReported(this.context, registrationIdReported);
    }

    static void setMessageStoreClass(Context context, Class<? extends MessageStore> messageStoreClass) {
        String value = null != messageStoreClass ? messageStoreClass.getName() : null;
        PreferenceHelper.saveString(context, MobileMessagingProperty.MESSAGE_STORE_CLASS, value);
    }

    public MessageStore getMessageStore() {
        if (!this.isMessageStoreEnabled()) {
            return null;
        }
        if (null != this.messageStore) {
            return this.messageStore;
        }
        Class<? extends MessageStore> messageStoreClass = null;
        try {
            messageStoreClass = this.getMessageStoreClass();
            this.messageStore = messageStoreClass.newInstance();
            return this.messageStore;
        }
        catch (Exception e) {
            throw new MessageStoreInstantiationException("Can't create message store of type: " + messageStoreClass, e);
        }
    }

    protected Class<? extends MessageStore> getMessageStoreClass() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.MESSAGE_STORE_CLASS);
    }

    public boolean isMessageStoreEnabled() {
        return null != this.getMessageStoreClass();
    }

    protected MobileMessagingStats getStats() {
        return this.stats;
    }

    public void setLastHttpException(Exception lastHttpException) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION, ExceptionUtils.stacktrace(lastHttpException));
    }

    public String getLastHttpException() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.LAST_HTTP_EXCEPTION);
    }

    private void setApplicationCode(String applicationCode) {
        if (StringUtils.isBlank(applicationCode)) {
            throw new IllegalArgumentException("applicationCode is mandatory! Get one here: https://portal.infobip.com/push/applications");
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.APPLICATION_CODE, applicationCode);
    }

    public static String getApplicationCode(Context context) {
        return PreferenceHelper.findString(context, MobileMessagingProperty.APPLICATION_CODE);
    }

    static void setApiUri(Context context, String apiUri) {
        if (StringUtils.isBlank(apiUri)) {
            throw new IllegalArgumentException("apiUri is mandatory! If in doubt, use " + MobileMessagingProperty.API_URI.getDefaultValue());
        }
        PreferenceHelper.saveString(context, MobileMessagingProperty.API_URI, apiUri);
    }

    public String getApiUri() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.API_URI);
    }

    static void setReportCarrierInfo(Context context, boolean reportCarrierInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_CARRIER_INFO, reportCarrierInfo);
    }

    static void setReportSystemInfo(Context context, boolean reportSystemInfo) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.REPORT_SYSTEM_INFO, reportSystemInfo);
    }

    private static void cleanup(Context context) {
        String gcmSenderID = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_SENDER_ID);
        String gcmToken = PreferenceHelper.findString(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        Intent intent = new Intent("org.infobip.mobile.messaging.gcm.token.cleanup", null, context, MobileMessagingGcmIntentService.class);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_SENDER_ID", gcmSenderID);
        intent.putExtra("org.infobip.mobile.messaging.gcm.GCM_TOKEN", gcmToken);
        context.startService(intent);
        PreferenceHelper.remove(context, MobileMessagingProperty.GCM_REGISTRATION_ID);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_REGISTRATION_ID);
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GCM_REGISTRATION_ID_REPORTED, false);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.USER_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.INFOBIP_UNREPORTED_SEEN_MESSAGE_IDS);
        PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.remove(context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
    }

    public static void setGeofencingActivated(Context context, boolean activated) {
        PreferenceHelper.saveBoolean(context, MobileMessagingProperty.GEOFENCING_ACTIVATED, activated);
    }

    public static boolean isGeofencingActivated(Context context) {
        return PreferenceHelper.findBoolean(context, MobileMessagingProperty.GEOFENCING_ACTIVATED);
    }

    public void activateGeofencing() {
        this.activateGeofencing(this.geofencing);
    }

    void activateGeofencing(Geofencing geofencing) {
        this.geofencing = geofencing;
        if (geofencing == null) {
            return;
        }
        MobileMessagingCore.setGeofencingActivated(this.context, true);
        geofencing.activate();
    }

    void deactivateGeofencing() {
        if (this.geofencing == null) {
            return;
        }
        MobileMessagingCore.setGeofencingActivated(this.context, false);
        this.geofencing.deactivate();
        this.geofencing = null;
    }

    void syncUserData(UserData userData, MobileMessaging.ResultListener<UserData> listener) {
        UserData userDataToReport = new UserData();
        if (userData != null) {
            String existingUserId;
            UserData existingData = this.getUnreportedUserData();
            String userId = userData.getExternalUserId();
            String string = existingUserId = existingData != null ? existingData.getExternalUserId() : null;
            if (!StringUtils.isEqual(userId, existingUserId)) {
                PreferenceHelper.remove(this.context, MobileMessagingProperty.USER_DATA);
                existingData = null;
            }
            userDataToReport = UserData.merge(existingData, userData);
        } else {
            String externalUserId;
            UserData existingUserData = this.getUserData();
            String string = externalUserId = existingUserData != null ? existingUserData.getExternalUserId() : null;
            if (externalUserId != null) {
                userDataToReport.setExternalUserId(externalUserId);
            }
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA, userDataToReport.toString());
        this.userDataSynchronizer.sync(this.context, this.getStats(), this.taskExecutor, listener);
    }

    public UserData getUserData() {
        UserData existing = null;
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.USER_DATA)) {
            existing = new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.USER_DATA));
        }
        return UserData.merge(existing, this.getUnreportedUserData());
    }

    public UserData getUnreportedUserData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA)) {
            return new UserData(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA));
        }
        return null;
    }

    public void setUserDataReportedWithError() {
        this.setUserDataReported(null);
    }

    public void setUserDataReported(UserData userData) {
        if (userData != null) {
            PreferenceHelper.saveString(this.context, MobileMessagingProperty.USER_DATA, userData.toString());
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_USER_DATA);
    }

    void sendMessages(MobileMessaging.ResultListener<Message[]> listener, Message ... messages) {
        if (this.isMessageStoreEnabled()) {
            this.getMessageStore().save(this.context, messages);
        }
        this.messageSender.send(this.context, this.getStats(), this.taskExecutor, listener, messages);
    }

    public void readSystemData() {
        boolean reportEnabled = PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.REPORT_SYSTEM_INFO);
        SystemData data = new SystemData(SoftwareInformation.getLibraryVersion(), reportEnabled ? SystemInformation.getAndroidSystemVersion() : "", reportEnabled ? DeviceInformation.getDeviceManufacturer() : "", reportEnabled ? DeviceInformation.getDeviceModel() : "", reportEnabled ? SoftwareInformation.getAppVersion(this.context) : "", MobileMessagingCore.isGeofencingActivated(this.context));
        Integer hash = PreferenceHelper.findInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH);
        if (hash.intValue() == data.hashCode()) {
            return;
        }
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA, data.toString());
    }

    public SystemData getUnreportedSystemData() {
        if (PreferenceHelper.contains(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA)) {
            return new SystemData(PreferenceHelper.findString(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA));
        }
        return null;
    }

    public void setSystemDataReported() {
        SystemData systemData = this.getUnreportedSystemData();
        if (systemData == null) {
            return;
        }
        PreferenceHelper.remove(this.context, MobileMessagingProperty.UNREPORTED_SYSTEM_DATA);
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.REPORTED_SYSTEM_DATA_HASH, systemData.hashCode());
    }

    public ArrayList<GeoReport> removeUnreportedGeoEvents(final Context context) {
        return PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<ArrayList<GeoReport>>(){

            @Override
            public ArrayList<GeoReport> run() {
                JsonSerializer deserializer = new JsonSerializer();
                String[] unreportedGeoEventsJsons = PreferenceHelper.findStringArray(context, MobileMessagingProperty.UNREPORTED_GEO_EVENTS);
                ArrayList<GeoReport> reports = new ArrayList<GeoReport>();
                for (String unreportedGeoEventJson : unreportedGeoEventsJsons) {
                    reports.add((GeoReport)deserializer.deserialize(unreportedGeoEventJson, GeoReport.class));
                }
                PreferenceHelper.remove(context, MobileMessagingProperty.UNREPORTED_GEO_EVENTS);
                return reports;
            }
        });
    }

    public void addUnreportedGeoEvents(final List<GeoReport> reports) {
        PreferenceHelper.runTransaction(new PreferenceHelper.Transaction<Void>(){

            @Override
            public Void run() {
                JsonSerializer serializer = new JsonSerializer();
                for (GeoReport report : reports) {
                    PreferenceHelper.appendToStringArray(MobileMessagingCore.this.context, MobileMessagingProperty.UNREPORTED_GEO_EVENTS, serializer.serialize((Object)report));
                }
                return null;
            }
        });
    }

    static void handleBootCompleted(Context context) {
        Geofencing.scheduleRefresh(context);
    }

    public static final class Builder {
        private final Application application;
        private NotificationSettings notificationSettings = null;
        private String applicationCode = null;
        private Geofencing geofencing;

        public Builder(Application application) {
            if (null == application) {
                throw new IllegalArgumentException("application is mandatory!");
            }
            this.application = application;
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withDisplayNotification(NotificationSettings notificationSettings) {
            this.notificationSettings = notificationSettings;
            return this;
        }

        public Builder withApplicationCode(String applicationCode) {
            this.validateWithParam(applicationCode);
            this.applicationCode = applicationCode;
            return this;
        }

        public Builder withGeofencing(Geofencing geofencing) {
            this.geofencing = geofencing;
            return this;
        }

        public MobileMessagingCore build() {
            if (!this.applicationCode.equals(MobileMessagingCore.getApplicationCode(this.application.getApplicationContext()))) {
                MobileMessagingCore.cleanup((Context)this.application);
            }
            MobileMessagingCore mobileMessagingCore = new MobileMessagingCore((Context)this.application);
            instance = mobileMessagingCore;
            mobileMessagingCore.setNotificationSettings(this.notificationSettings);
            mobileMessagingCore.setApplicationCode(this.applicationCode);
            mobileMessagingCore.activityLifecycleMonitor = new ActivityLifecycleMonitor(this.application.getApplicationContext());
            mobileMessagingCore.mobileNetworkStateListener = new MobileNetworkStateListener((Context)this.application);
            mobileMessagingCore.playServicesSupport = new PlayServicesSupport();
            mobileMessagingCore.playServicesSupport.checkPlayServices(this.application.getApplicationContext());
            mobileMessagingCore.readSystemData();
            mobileMessagingCore.activateGeofencing(this.geofencing);
            return mobileMessagingCore;
        }
    }
}

