/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.util.StringUtils;

public class SystemData {
    String sdkVersion;
    String osVersion;
    String deviceManufacturer;
    String deviceModel;
    String applicationVersion;
    Boolean geofencing;

    public SystemData(String json) {
        SystemData data = (SystemData)new JsonSerializer().deserialize(json, SystemData.class);
        if (data == null) {
            return;
        }
        this.sdkVersion = data.sdkVersion;
        this.osVersion = data.osVersion;
        this.deviceManufacturer = data.deviceManufacturer;
        this.deviceModel = data.deviceModel;
        this.applicationVersion = data.applicationVersion;
        this.geofencing = data.geofencing;
    }

    public SystemData(String sdkVersion, String osVersion, String deviceManufacturer, String deviceModel, String applicationVersion, Boolean geofencing) {
        this.sdkVersion = sdkVersion;
        this.osVersion = osVersion;
        this.deviceManufacturer = deviceManufacturer;
        this.deviceModel = deviceModel;
        this.applicationVersion = applicationVersion;
        this.geofencing = geofencing;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public Boolean getGeofencing() {
        return this.geofencing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = SystemData.appendToHash(result, 31, this.sdkVersion);
        result = SystemData.appendToHash(result, 31, this.osVersion);
        result = SystemData.appendToHash(result, 31, this.deviceManufacturer);
        result = SystemData.appendToHash(result, 31, this.deviceModel);
        result = SystemData.appendToHash(result, 31, this.applicationVersion);
        result = SystemData.appendToHash(result, 31, this.geofencing);
        return result;
    }

    private static int appendToHash(int result, int prime, Object o) {
        return prime * result + (o == null ? 0 : o.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemData other = (SystemData)o;
        return StringUtils.isEqual(this.sdkVersion, other.sdkVersion) && StringUtils.isEqual(this.osVersion, other.osVersion) && StringUtils.isEqual(this.deviceManufacturer, other.deviceManufacturer) && StringUtils.isEqual(this.deviceModel, other.deviceModel) && StringUtils.isEqual(this.applicationVersion, other.applicationVersion) && this.geofencing == other.geofencing;
    }

    public String toString() {
        return new JsonSerializer().serialize((Object)this);
    }
}

