/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.location.Geofence;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class Area
implements Parcelable {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="latitude")
    private Double latitude;
    @SerializedName(value="longitude")
    private Double longitude;
    @SerializedName(value="radiusInMeters")
    private Integer radius;
    public static final Parcelable.Creator<Area> CREATOR = new Parcelable.Creator<Area>(){

        public Area createFromParcel(Parcel in) {
            return new Area(in);
        }

        public Area[] newArray(int size) {
            return new Area[size];
        }
    };

    public Area(String id, String title, Double latitude, Double longitude, Integer radius) {
        this.id = id;
        this.title = title;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
    }

    protected Area(Parcel in) {
        this.id = in.readString();
        this.title = in.readString();
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.radius = in.readInt();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Integer getRadius() {
        return this.radius;
    }

    Geofence toGeofence(Date expiryDate) {
        Long expirationDurationMillis = 0L;
        if (expiryDate != null) {
            expirationDurationMillis = expiryDate.getTime() - System.currentTimeMillis();
        }
        if (expirationDurationMillis <= 0L) {
            expirationDurationMillis = -1L;
        }
        return new Geofence.Builder().setCircularRegion(this.getLatitude().doubleValue(), this.getLongitude().doubleValue(), (float)this.getRadius().intValue()).setRequestId(this.getId()).setTransitionTypes(1).setExpirationDuration(expirationDurationMillis.longValue()).build();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.id);
        parcel.writeString(this.title);
        parcel.writeDouble(this.latitude.doubleValue());
        parcel.writeDouble(this.longitude.doubleValue());
        parcel.writeInt(this.radius.intValue());
    }

    public boolean isValid() {
        return this.getId() != null && this.getLatitude() != null && this.getLongitude() != null && this.getRadius() != null;
    }
}

