/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.geo;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import java.io.Serializable;
import java.util.ArrayList;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.mobile.UnsuccessfulResult;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingTask;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;

public class GeoReporter {
    public void report(final Context context, final MobileMessagingStats stats) {
        final MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(context);
        final ArrayList<GeoReport> reports = mobileMessagingCore.removeUnreportedGeoEvents(context);
        if (reports.isEmpty()) {
            return;
        }
        new GeoReportingTask(context){

            protected void onPostExecute(UnsuccessfulResult unused) {
                Intent geoReportsSent = new Intent(Event.GEOFENCE_EVENTS_REPORTED.getKey());
                geoReportsSent.putParcelableArrayListExtra("org.infobip.mobile.messaging.geofence.reports", reports);
                context.sendBroadcast(geoReportsSent);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(geoReportsSent);
            }

            protected void onCancelled(UnsuccessfulResult result) {
                stats.reportError(MobileMessagingError.GEO_REPORTING_ERROR);
                mobileMessagingCore.addUnreportedGeoEvents(reports);
                Intent seenStatusReportError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                seenStatusReportError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)result.getError());
                context.sendBroadcast(seenStatusReportError);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(seenStatusReportError);
            }
        }.execute(reports.toArray(new GeoReport[reports.size()]));
    }
}

