/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.stats;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import org.infobip.mobile.messaging.stats.MobileMessagingError;

public class MobileMessagingStats {
    public static final String STATS_KEY_BASE = "org.infobip.mobile.messaging.stats.";
    private final Context context;

    public MobileMessagingStats(Context context) {
        this.context = context;
    }

    public static String getKey(MobileMessagingError mobileMessagingError) {
        return STATS_KEY_BASE + mobileMessagingError.name();
    }

    public long getErrorCount(MobileMessagingError mobileMessagingError) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        return sharedPreferences.getLong(MobileMessagingStats.getKey(mobileMessagingError), 0L);
    }

    public synchronized void reportError(MobileMessagingError mobileMessagingError) {
        this.saveLong(mobileMessagingError, this.getErrorCount(mobileMessagingError) + 1L);
    }

    public void resetErrors() {
        for (MobileMessagingError e : MobileMessagingError.values()) {
            this.resetError(e);
        }
    }

    public synchronized void resetError(MobileMessagingError mobileMessagingError) {
        this.saveLong(mobileMessagingError, this.getErrorCount(mobileMessagingError));
    }

    private void saveLong(MobileMessagingError mobileMessagingError, long value) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        sharedPreferences.edit().putLong(MobileMessagingStats.getKey(mobileMessagingError), value).apply();
    }
}

