/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.util.PreferenceHelper;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;

public class NotificationSettings {
    private final Context context;

    NotificationSettings(Context context) {
        this.context = context;
    }

    public Class<?> getCallbackActivity() {
        return PreferenceHelper.findClass(this.context, MobileMessagingProperty.CALLBACK_ACTIVITY);
    }

    private void setCallbackActivity(Class<?> callbackActivity) {
        if (null == callbackActivity) {
            throw new IllegalArgumentException("callbackActivity is mandatory! You should use the activity that will display received messages.");
        }
        PreferenceHelper.saveClass(this.context, MobileMessagingProperty.CALLBACK_ACTIVITY, callbackActivity);
    }

    public boolean isDisplayNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.DISPLAY_NOTIFICATION_ENABLED);
    }

    public String getDefaultTitle() {
        return PreferenceHelper.findString(this.context, MobileMessagingProperty.DEFAULT_TITLE);
    }

    private void setDefaultTitle(String defaultTitle) {
        PreferenceHelper.saveString(this.context, MobileMessagingProperty.DEFAULT_TITLE, defaultTitle);
    }

    public int getDefaultIcon() {
        return PreferenceHelper.findInt(this.context, MobileMessagingProperty.DEFAULT_ICON);
    }

    private void setDefaultIcon(int defaultIcon) {
        if (null == this.context.getResources().getDrawable(defaultIcon)) {
            throw new IllegalArgumentException("defaultIcon doesn't exist: " + defaultIcon);
        }
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.DEFAULT_ICON, defaultIcon);
    }

    public int getIntentFlags() {
        return PreferenceHelper.findInt(this.context, MobileMessagingProperty.INTENT_FLAGS);
    }

    private void setIntentFlags(int intentFlags) {
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.INTENT_FLAGS, intentFlags);
    }

    public int getPendingIntentFlags() {
        return PreferenceHelper.findInt(this.context, MobileMessagingProperty.PENDING_INTENT_FLAGS);
    }

    private void setPendingIntentFlags(int pendingIntentFlags) {
        PreferenceHelper.saveInt(this.context, MobileMessagingProperty.PENDING_INTENT_FLAGS, pendingIntentFlags);
    }

    public boolean isNotificationAutoCancel() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.NOTIFICATION_AUTO_CANCEL);
    }

    private void setNotificationAutoCancel(boolean notificationAutoCancel) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.NOTIFICATION_AUTO_CANCEL, notificationAutoCancel);
    }

    public boolean isForegroundNotificationEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.FOREGROUND_NOTIFICATION_ENABLED);
    }

    private void setForegroundNotificationEnabled(boolean foregroundNotificationEnabled) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.FOREGROUND_NOTIFICATION_ENABLED, foregroundNotificationEnabled);
    }

    public boolean isForegroundNotificationDisabled() {
        return !this.isForegroundNotificationEnabled();
    }

    private void setMultipleNotificationsEnabled(boolean multipleNotificationsEnabled) {
        PreferenceHelper.saveBoolean(this.context, MobileMessagingProperty.MULTIPLE_NOTIFICATIONS_ENABLED, multipleNotificationsEnabled);
    }

    public boolean areMultipleNotificationsEnabled() {
        return PreferenceHelper.findBoolean(this.context, MobileMessagingProperty.MULTIPLE_NOTIFICATIONS_ENABLED);
    }

    public static final class Builder {
        private final Context context;
        private int defaultIcon = (Integer)MobileMessagingProperty.DEFAULT_ICON.getDefaultValue();
        private String defaultTitle = (String)MobileMessagingProperty.DEFAULT_TITLE.getDefaultValue();
        private Class<?> callbackActivity = (Class)MobileMessagingProperty.CALLBACK_ACTIVITY.getDefaultValue();
        private int intentFlags = (Integer)MobileMessagingProperty.INTENT_FLAGS.getDefaultValue();
        private int pendingIntentFlags = (Integer)MobileMessagingProperty.PENDING_INTENT_FLAGS.getDefaultValue();
        private boolean notificationAutoCancel = (Boolean)MobileMessagingProperty.NOTIFICATION_AUTO_CANCEL.getDefaultValue();
        private boolean foregroundNotificationEnabled = (Boolean)MobileMessagingProperty.FOREGROUND_NOTIFICATION_ENABLED.getDefaultValue();
        private boolean multipleNotificationsEnabled;

        public Builder(Context context) {
            if (null == context) {
                throw new IllegalArgumentException("context is mandatory!");
            }
            this.context = context;
            this.loadCallbackActivity(context);
            this.loadDefaultTitle(context);
            this.loadDefaultIcon(context);
        }

        private void loadCallbackActivity(Context context) {
            Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (launchIntent == null) {
                return;
            }
            ComponentName componentName = launchIntent.getComponent();
            if (componentName == null) {
                return;
            }
            String className = componentName.getClassName();
            if (StringUtils.isBlank(className)) {
                return;
            }
            try {
                this.callbackActivity = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        private void loadDefaultTitle(Context context) {
            String defaultTitle;
            int resource = ResourceLoader.loadResourceByName(context, "string", "app_name");
            if (resource > 0 && StringUtils.isNotBlank(defaultTitle = context.getResources().getString(resource))) {
                this.defaultTitle = defaultTitle;
            }
        }

        private void loadDefaultIcon(Context context) {
            int resource = SoftwareInformation.getAppIconResourceId(context);
            if (resource > 0) {
                this.defaultIcon = resource;
            }
        }

        private void validateWithParam(Object o) {
            if (null != o) {
                return;
            }
            throw new IllegalArgumentException("Can't use 'with' method with null argument!");
        }

        public Builder withCallbackActivity(Class<?> callbackActivity) {
            this.validateWithParam(callbackActivity);
            this.callbackActivity = callbackActivity;
            return this;
        }

        public Builder withDefaultTitle(String defaultTitle) {
            this.validateWithParam(defaultTitle);
            this.defaultTitle = defaultTitle;
            return this;
        }

        public Builder withDefaultIcon(int defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public Builder withIntentFlags(int intentFlags) {
            this.intentFlags = intentFlags;
            return this;
        }

        public Builder withPendingIntentFlags(int pendingIntentFlags) {
            this.pendingIntentFlags = pendingIntentFlags;
            return this;
        }

        public Builder withNotificationAutoCancel() {
            this.notificationAutoCancel = true;
            return this;
        }

        public Builder withMultipleNotifications() {
            this.multipleNotificationsEnabled = true;
            return this;
        }

        public Builder withoutNotificationAutoCancel() {
            this.notificationAutoCancel = false;
            return this;
        }

        public Builder withoutForegroundNotification() {
            this.foregroundNotificationEnabled = false;
            return this;
        }

        public NotificationSettings build() {
            NotificationSettings notificationSettings = new NotificationSettings(this.context.getApplicationContext());
            notificationSettings.setDefaultTitle(this.defaultTitle);
            notificationSettings.setDefaultIcon(this.defaultIcon);
            notificationSettings.setCallbackActivity(this.callbackActivity);
            notificationSettings.setIntentFlags(this.intentFlags);
            notificationSettings.setPendingIntentFlags(this.pendingIntentFlags);
            notificationSettings.setNotificationAutoCancel(this.notificationAutoCancel);
            notificationSettings.setForegroundNotificationEnabled(this.foregroundNotificationEnabled);
            notificationSettings.setMultipleNotificationsEnabled(this.multipleNotificationsEnabled);
            return notificationSettings;
        }
    }
}

