/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.gcm;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.SharedPreferencesMessageStore;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileMessageHandler {
    private SharedPreferencesMessageStore messageStore;

    public void handleMessage(Context context, Intent intent) {
        if (!MobileMessagingCore.getInstance(context).isPushRegistrationEnabled()) {
            return;
        }
        String from = intent.getStringExtra("from");
        Bundle data = intent.getExtras();
        data.putLong("received_timestamp", System.currentTimeMillis());
        Message message = this.createMessage(from, data);
        if (StringUtils.isBlank(message.getMessageId())) {
            Log.w((String)"MobileMessaging", (String)"Ignoring message without messageId");
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Message received from: " + from));
        this.sendDeliveryReport(context, message);
        this.saveMessage(context, message);
        Log.d((String)"MobileMessaging", (String)("Message is silent: " + message.isSilent()));
        if (!message.isSilent()) {
            NotificationHandler.displayNotification(context, message);
        }
        Intent messageReceived = new Intent(Event.MESSAGE_RECEIVED.getKey());
        messageReceived.putExtras(message.getBundle());
        context.sendBroadcast(messageReceived);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messageReceived);
    }

    private void saveMessage(Context context, Message message) {
        if (!MobileMessagingCore.getInstance(context).isMessageStoreEnabled()) {
            Log.d((String)"MobileMessaging", (String)("Skipping save message: " + message.getMessageId()));
            if (message.getGeo() != null) {
                this.messageStore().save(context, message);
                Log.d((String)"MobileMessaging", (String)("Only save message that contains geofence areas: " + message.getMessageId()));
            }
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Saving message: " + message.getMessageId()));
        try {
            MobileMessagingCore.getInstance(context).getMessageStore().save(context, message);
        }
        catch (Exception e) {
            Log.e((String)"MobileMessaging", (String)("Error saving message: " + message.getMessageId()), (Throwable)e);
        }
    }

    private MessageStore messageStore() {
        if (this.messageStore == null) {
            this.messageStore = new SharedPreferencesMessageStore();
        }
        return this.messageStore;
    }

    private Message createMessage(String from, Bundle data) {
        Message message = Message.createFrom(data);
        message.setFrom(from);
        return message;
    }

    private void sendDeliveryReport(Context context, Message message) {
        if (StringUtils.isBlank(message.getMessageId())) {
            Log.e((String)"MobileMessaging", (String)("No ID received for message: " + message));
            return;
        }
        Log.d((String)"MobileMessaging", (String)("Sending DR: " + message.getMessageId()));
        MobileMessagingCore.getInstance(context).setMessagesDelivered(message.getMessageId());
    }
}

