/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.geo;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Parcelable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.util.Pair;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.geo.EventReport;
import org.infobip.mobile.messaging.api.geo.EventReports;
import org.infobip.mobile.messaging.geo.Area;
import org.infobip.mobile.messaging.geo.DeliveryTime;
import org.infobip.mobile.messaging.geo.Geo;
import org.infobip.mobile.messaging.geo.GeoEvent;
import org.infobip.mobile.messaging.geo.GeoEventType;
import org.infobip.mobile.messaging.geo.GeoReport;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.geo.GeoReporter;
import org.infobip.mobile.messaging.mobile.geo.GeoReportingResult;
import org.infobip.mobile.messaging.notification.NotificationHandler;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.infobip.mobile.messaging.storage.SharedPreferencesMessageStore;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.PreferenceHelper;

class GeoAreasHandler {
    private static final String TAG = "GeofenceTransitions";
    private static final String AREA_NOTIFIED_PREF_PREFIX = "org.infobip.mobile.messaging.geo.area.notified.";
    private static final String AREA_LAST_TIME_PREF_PREFIX = "org.infobip.mobile.messaging.geo.area.last.time.";
    private static final GeoEvent DEFAULT_NOTIFICATION_SETTINGS_FOR_ENTER = new GeoEvent(GeoEventType.entry, 1, 0L);
    private final MessageStore messageStore = new SharedPreferencesMessageStore();
    private final Context context;
    private static SparseArray<String> transitionNames = new SparseArray<String>(){
        {
            this.put(1, "GEOFENCE_TRANSITION_ENTER");
            this.put(2, "GEOFENCE_TRANSITION_EXIT");
            this.put(4, "GEOFENCE_TRANSITION_DWELL");
        }
    };
    private static SparseArray<String> geofencingErrors = new SparseArray<String>(){
        {
            this.put(1000, "Geofence not available");
            this.put(1001, "Too many geofences");
            this.put(1002, "Too many pending intents");
        }
    };
    private static SparseArray<Event> transitionBroadcasts = new SparseArray<Event>(){
        {
            this.put(1, (Object)Event.GEOFENCE_AREA_ENTERED);
        }
    };
    private static SparseArray<GeoEventType> transitionReportEvents = new SparseArray<GeoEventType>(){
        {
            this.put(1, (Object)GeoEventType.entry);
        }
    };

    GeoAreasHandler(Context context) {
        this.context = context;
    }

    void handleTransition(Intent intent) {
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent == null) {
            return;
        }
        if (geofencingEvent.hasError()) {
            Log.e((String)TAG, (String)("ERROR:" + (String)geofencingErrors.get(geofencingEvent.getErrorCode())));
            return;
        }
        Map<Message, List<Area>> messagesAndAreas = this.findMessagesAndAreasForTriggeringGeofences(this.context, geofencingEvent.getTriggeringGeofences());
        if (messagesAndAreas == null || messagesAndAreas.isEmpty()) {
            return;
        }
        ArrayList<GeoReport> geoReports = new ArrayList<GeoReport>();
        ArrayList<Pair<Geo, Message>> geoDataToNotify = new ArrayList<Pair<Geo, Message>>();
        int geofenceTransition = geofencingEvent.getGeofenceTransition();
        for (Message message : messagesAndAreas.keySet()) {
            List<Area> geofenceAreasList = messagesAndAreas.get(message);
            this.logGeofences(geofenceAreasList, geofenceTransition);
            for (final Area area : geofenceAreasList) {
                if (!this.shouldReportTransition(message, area, geofenceTransition)) continue;
                Location triggeringLocation = geofencingEvent.getTriggeringLocation();
                Geo geoToReportAndNotify = new Geo(triggeringLocation.getLatitude(), triggeringLocation.getLongitude(), (List<Area>)new ArrayList<Area>(){
                    {
                        this.add(area);
                    }
                });
                geoDataToNotify.add((Pair<Geo, Message>)new Pair((Object)geoToReportAndNotify, (Object)message));
                geoReports.add(new GeoReport(message.getGeo().getCampaignId(), message.getMessageId(), (GeoEventType)((Object)transitionReportEvents.get(geofenceTransition)), area, System.currentTimeMillis()));
            }
        }
        if (!geoReports.isEmpty() && !geoDataToNotify.isEmpty()) {
            MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
            EventReport[] reports = GeoReporter.prepareEventReport(geoReports.toArray(new GeoReport[geoReports.size()]));
            List<String> finishedCampaignIds = Arrays.asList(mobileMessagingCore.getFinishedCampaignIds());
            List<String> suspendedCampaignIds = Arrays.asList(mobileMessagingCore.getSuspendedCampaignIds());
            try {
                GeoReportingResult result = new GeoReportingResult(MobileApiResourceProvider.INSTANCE.getMobileApiGeo(this.context).report(new EventReports(reports)));
                if (result.getFinishedCampaignIds() != null) {
                    finishedCampaignIds = Arrays.asList(result.getFinishedCampaignIds());
                }
                if (result.getSuspendedCampaignIds() != null) {
                    suspendedCampaignIds = Arrays.asList(result.getSuspendedCampaignIds());
                }
                GeoReporter.handleSuccess(this.context, mobileMessagingCore, result, geoReports);
            }
            catch (Exception e) {
                GeoReporter.handleError(this.context, mobileMessagingCore, e, geoReports);
            }
            this.displayNotificationsForActiveCampaigns(geoDataToNotify, geofenceTransition, finishedCampaignIds, suspendedCampaignIds);
        }
    }

    private void displayNotificationsForActiveCampaigns(ArrayList<Pair<Geo, Message>> geoDataToNotify, int geofenceTransition, List<String> finishedCampaignIds, List<String> suspendedCampaignIds) {
        for (Pair<Geo, Message> geoData : geoDataToNotify) {
            Geo geo = (Geo)geoData.first;
            Message message = (Message)geoData.second;
            if (finishedCampaignIds.contains(message.getGeo().getCampaignId()) || suspendedCampaignIds.contains(message.getGeo().getCampaignId())) continue;
            for (Area area : geo.getAreasList()) {
                this.setLastNotificationTimeForArea(message.getMessageId(), area.getId(), geofenceTransition, System.currentTimeMillis());
                this.setNumberOfDisplayedNotificationsForArea(message.getMessageId(), area.getId(), geofenceTransition, this.getNumberOfDisplayedNotificationsForArea(message.getMessageId(), area.getId(), geofenceTransition) + 1);
            }
            this.notifyAboutTransition(this.context, geo, geofenceTransition, (Message)geoData.second);
        }
    }

    private boolean shouldReportTransition(Message message, Area area, int geofenceTransition) {
        int numberOfDisplayedNotifications = this.getNumberOfDisplayedNotificationsForArea(message.getMessageId(), area.getId(), geofenceTransition);
        long lastNotificationTimeForArea = this.getLastNotificationTimeForArea(message.getMessageId(), area.getId(), geofenceTransition);
        Geo geo = message.getGeo();
        GeoEvent settings = this.getNotificationSettingsForTransition(geo.getEvents(), geofenceTransition);
        boolean isInDeliveryWindow = this.checkIsAreaInDeliveryWindow(geo.getDeliveryTime());
        return settings != null && isInDeliveryWindow && (settings.getLimit() > numberOfDisplayedNotifications || settings.getLimit() == 0) && TimeUnit.MINUTES.toMillis(settings.getTimeoutInMinutes()) < System.currentTimeMillis() - lastNotificationTimeForArea && this.geoEventMatchesTransition(settings, geofenceTransition) && !geo.isExpired();
    }

    private boolean checkIsAreaInDeliveryWindow(DeliveryTime deliveryTime) {
        try {
            if (deliveryTime == null) {
                return true;
            }
            String daysPayload = deliveryTime.getDays();
            if (!this.shouldDeliverToday(daysPayload)) {
                return false;
            }
            String timeInterval = deliveryTime.getTimeInterval();
            return this.checkIsDeliveryInTimeInterval(timeInterval);
        }
        catch (ParseException e) {
            Log.e((String)"MobileMessaging", (String)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private boolean shouldDeliverToday(String daysPayload) {
        String[] days = null;
        if (daysPayload == null) {
            return false;
        }
        try {
            days = daysPayload.split(",");
        }
        catch (PatternSyntaxException e) {
            Log.e((String)"MobileMessaging", (String)e.getMessage(), (Throwable)e);
        }
        if (days == null) {
            return false;
        }
        int dayOfMonthISO8601 = DateTimeUtil.dayOfWeekISO8601();
        for (String day : days) {
            if (!day.equalsIgnoreCase(String.valueOf(dayOfMonthISO8601))) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsDeliveryInTimeInterval(String timeInterval) throws ParseException {
        if (timeInterval == null) {
            return false;
        }
        String[] timeIntervalStartEnd = timeInterval.split("/");
        String startTime = timeIntervalStartEnd[0];
        String endTime = timeIntervalStartEnd[1];
        return DateTimeUtil.isCurrentTimeBetweenDates(startTime, endTime);
    }

    private GeoEvent getNotificationSettingsForTransition(List<GeoEvent> eventFilters, int geofenceTransition) {
        if (eventFilters == null || eventFilters.isEmpty()) {
            return DEFAULT_NOTIFICATION_SETTINGS_FOR_ENTER;
        }
        for (GeoEvent e : eventFilters) {
            if (!this.geoEventMatchesTransition(e, geofenceTransition)) continue;
            return e;
        }
        return null;
    }

    private String areaNotificationNumKey(String messageId, String areaId, int geofenceTransition) {
        return AREA_NOTIFIED_PREF_PREFIX + messageId + "-" + areaId + "-" + geofenceTransition;
    }

    private String areaNotificationTimeKey(String messageId, String areaId, int geofenceTransition) {
        return AREA_LAST_TIME_PREF_PREFIX + messageId + "-" + areaId + "-" + geofenceTransition;
    }

    private boolean geoEventMatchesTransition(GeoEvent event, int geofenceTransition) {
        return event.getType().equals((Object)DEFAULT_NOTIFICATION_SETTINGS_FOR_ENTER.getType()) && geofenceTransition == 1;
    }

    private int getNumberOfDisplayedNotificationsForArea(String messageId, String areaId, int geofenceTransition) {
        return PreferenceHelper.findInt(this.context, this.areaNotificationNumKey(messageId, areaId, geofenceTransition), 0);
    }

    private void setNumberOfDisplayedNotificationsForArea(String messageId, String areaId, int geofenceTransition, int n) {
        PreferenceHelper.saveInt(this.context, this.areaNotificationNumKey(messageId, areaId, geofenceTransition), n);
    }

    private long getLastNotificationTimeForArea(String messageId, String areaId, int geofenceTransition) {
        return PreferenceHelper.findLong(this.context, this.areaNotificationTimeKey(messageId, areaId, geofenceTransition), 0L);
    }

    private void setLastNotificationTimeForArea(String messageId, String areaId, int geofenceTransition, long timeMs) {
        PreferenceHelper.saveLong(this.context, this.areaNotificationTimeKey(messageId, areaId, geofenceTransition), timeMs);
    }

    private void notifyAboutTransition(Context context, Geo geo, int geofenceTransition, Message message) {
        NotificationHandler.displayNotification(context, message);
        this.sendGeoEventBroadcast(context, geofenceTransition, geo, message);
    }

    private void sendGeoEventBroadcast(Context context, int geofenceTransition, Geo geo, Message message) {
        Event event = (Event)((Object)transitionBroadcasts.get(geofenceTransition));
        if (event == null) {
            return;
        }
        Intent geofenceIntent = new Intent(event.getKey());
        geofenceIntent.putExtra("org.infobip.mobile.messaging.geofence.areas", (Parcelable)geo);
        geofenceIntent.putExtras(message.getBundle());
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(geofenceIntent);
        context.sendBroadcast(geofenceIntent);
    }

    private void logGeofences(List<Area> areas, int transition) {
        for (Area a : areas) {
            Log.i((String)TAG, (String)((String)transitionNames.get(transition) + " (" + a.getTitle() + ") LAT:" + a.getLatitude() + " LON:" + a.getLongitude() + " RAD:" + a.getRadius()));
        }
    }

    private Map<Message, List<Area>> findMessagesAndAreasForTriggeringGeofences(Context context, List<Geofence> geofences) {
        HashMap<Message, List<Area>> messagesAndAreas = new HashMap<Message, List<Area>>();
        for (Message message : this.messageStore.findAll(context)) {
            Geo geo = message.getGeo();
            if (geo == null || geo.getAreasList() == null || geo.getAreasList().isEmpty()) continue;
            List<Area> campaignAreas = geo.getAreasList();
            ArrayList<Area> triggeredAreas = new ArrayList<Area>();
            for (Area area : campaignAreas) {
                for (Geofence geofence : geofences) {
                    if (!geofence.getRequestId().equalsIgnoreCase(area.getId())) continue;
                    triggeredAreas.add(area);
                }
            }
            if (triggeredAreas.isEmpty()) continue;
            messagesAndAreas.put(message, triggeredAreas);
        }
        return messagesAndAreas;
    }
}

