/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.data;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.SystemData;
import org.infobip.mobile.messaging.api.data.SystemDataReport;
import org.infobip.mobile.messaging.mobile.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobile.data.SystemDataReportResult;
import org.infobip.mobile.messaging.util.StringUtils;

class SystemDataReportTask
extends AsyncTask<SystemDataReport, Void, SystemDataReportResult> {
    private final Context context;

    SystemDataReportTask(Context context) {
        this.context = context;
    }

    protected SystemDataReportResult doInBackground(SystemDataReport ... params) {
        if (params.length < 1) {
            Log.e((String)"MobileMessaging", (String)"System data is empty, cannot report!");
            return new SystemDataReportResult(new Exception("Syncing system data: request data is empty"));
        }
        SystemDataReport report = params[0];
        SystemData data = new SystemData(report.getSdkVersion(), report.getOsVersion(), report.getDeviceManufacturer(), report.getDeviceModel(), report.getApplicationVersion(), report.getGeofencing(), report.getNotificationsEnabled());
        MobileMessagingCore mobileMessagingCore = MobileMessagingCore.getInstance(this.context);
        String deviceApplicationInstanceId = mobileMessagingCore.getDeviceApplicationInstanceId();
        if (StringUtils.isBlank(deviceApplicationInstanceId)) {
            Log.w((String)"MobileMessaging", (String)"Can't report system data without valid registration");
            return new SystemDataReportResult(data, true);
        }
        try {
            MobileApiResourceProvider.INSTANCE.getMobileApiData(this.context).reportSystemData(deviceApplicationInstanceId, report);
            return new SystemDataReportResult(data);
        }
        catch (Exception e) {
            mobileMessagingCore.setLastHttpException(e);
            Log.e((String)"MobileMessaging", (String)"Error reporting system data!", (Throwable)e);
            this.cancel(true);
            Intent userDataSyncError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
            userDataSyncError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)e);
            this.context.sendBroadcast(userDataSyncError);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(userDataSyncError);
            return new SystemDataReportResult(e);
        }
    }
}

