/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.mobile.messages;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.messages.MoMessageDelivery;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.mobile.messages.SendMessageResult;
import org.infobip.mobile.messaging.mobile.messages.SendMessageTask;
import org.infobip.mobile.messaging.stats.MobileMessagingError;
import org.infobip.mobile.messaging.stats.MobileMessagingStats;
import org.infobip.mobile.messaging.storage.MessageStore;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageSender {
    public void send(final Context context, final MobileMessagingStats stats, Executor executor, final MobileMessaging.ResultListener<Message[]> listener, final Message ... messages) {
        new SendMessageTask(context){

            protected void onPostExecute(SendMessageResult sendMessageResult) {
                if (sendMessageResult.hasError()) {
                    Log.e((String)"MobileMessaging", (String)"MobileMessaging API returned error (sending message)!");
                    stats.reportError(MobileMessagingError.MESSAGE_SEND_ERROR);
                    Intent sendMessageError = new Intent(Event.API_COMMUNICATION_ERROR.getKey());
                    sendMessageError.putExtra("org.infobip.mobile.messaging.exception", (Serializable)sendMessageResult.getError());
                    context.sendBroadcast(sendMessageError);
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(sendMessageError);
                    MessageSender.this.reportFailedMessages(context, messages, sendMessageResult.getError(), listener);
                    return;
                }
                MessageSender.this.reportMessageDelivery(context, sendMessageResult.getMessageDeliveries(), listener);
            }
        }.executeOnExecutor(executor, messages);
    }

    private void reportMessageDelivery(Context context, MoMessageDelivery[] messageDeliveries, MobileMessaging.ResultListener<Message[]> listener) {
        ArrayList<Bundle> messageBundles = new ArrayList<Bundle>();
        JsonSerializer serializer = new JsonSerializer();
        for (MoMessageDelivery delivery : messageDeliveries) {
            Message message = MessageDelivery.fromJson(serializer.serialize((Object)delivery));
            messageBundles.add(message.getBundle());
        }
        this.reportMessages(context, listener, messageBundles);
    }

    private void reportFailedMessages(Context context, Message[] messages, Throwable error, MobileMessaging.ResultListener<Message[]> listener) {
        ArrayList<Bundle> messageBundles = new ArrayList<Bundle>();
        for (Message message : messages) {
            MessageDelivery.setStatus(message, Message.Status.ERROR, error.getMessage());
            messageBundles.add(message.getBundle());
        }
        this.reportMessages(context, listener, messageBundles);
    }

    private void reportMessages(Context context, MobileMessaging.ResultListener<Message[]> listener, ArrayList<Bundle> messageBundles) {
        List<Message> messageList = Message.createFrom(messageBundles);
        MessageStore messageStore = MobileMessagingCore.getInstance(context).getMessageStore();
        if (messageStore != null) {
            messageStore.save(context, messageList.toArray(new Message[messageList.size()]));
        }
        Intent messagesSent = new Intent(Event.MESSAGES_SENT.getKey());
        messagesSent.putParcelableArrayListExtra("org.infobip.mobile.messaging.messages", messageBundles);
        context.sendBroadcast(messagesSent);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(messagesSent);
        if (listener != null) {
            listener.onResult(messageList.toArray(new Message[messageList.size()]));
        }
    }

    private static class MessageDelivery
    extends Message {
        private MessageDelivery() {
        }

        static void setStatus(Message message, Message.Status status, String statusMessage) {
            if (message.getBundle() == null) {
                return;
            }
            message.getBundle().putString(Message.BundleField.STATUS.getKey(), status.getKey());
            message.getBundle().putString(Message.BundleField.STATUS_MESSAGE.getKey(), statusMessage);
        }

        public static Message fromJson(String json) {
            JSONObject object;
            try {
                object = new JSONObject(json);
            }
            catch (JSONException e) {
                Log.w((String)"MobileMessaging", (String)("Cannot parse message from JSON: " + e.getMessage()));
                Log.d((String)"MobileMessaging", (String)Log.getStackTraceString((Throwable)e));
                return new Message();
            }
            Bundle bundle = new Message().getBundle();
            bundle.putString(Message.BundleField.DESTINATION.getKey(), object.optString(JsonField.DESTINATION.getKey()));
            bundle.putString(Message.BundleField.MESSAGE_ID.getKey(), object.optString(JsonField.MESSAGE_ID.getKey()));
            bundle.putString(Message.BundleField.BODY.getKey(), object.optString(JsonField.TEXT.getKey()));
            if (object.has(JsonField.CUSTOM_PAYLOAD.getKey())) {
                bundle.putString(Message.BundleField.CUSTOM_PAYLOAD.getKey(), object.optJSONObject(JsonField.CUSTOM_PAYLOAD.getKey()).toString());
            }
            if (object.has(JsonField.STATUS_CODE.getKey())) {
                int statusId = object.optInt(JsonField.STATUS_CODE.getKey(), Message.Status.UNKNOWN.ordinal());
                for (Message.Status status : Message.Status.values()) {
                    if (status.ordinal() != statusId) continue;
                    bundle.putString(Message.BundleField.STATUS.getKey(), status.getKey());
                    break;
                }
            }
            bundle.putString(Message.BundleField.STATUS_MESSAGE.getKey(), object.optString(JsonField.STATUS.getKey()));
            return Message.createFrom(bundle);
        }

        static enum JsonField {
            MESSAGE_ID("messageId"),
            DESTINATION("destination"),
            TEXT("text"),
            CUSTOM_PAYLOAD("customPayload"),
            STATUS_CODE("statusCode"),
            STATUS("status");

            private final String key;

            private JsonField(String key) {
                this.key = key;
            }

            public String getKey() {
                return this.key;
            }
        }
    }
}

