/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.util.Random;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.app.ActivityLifecycleMonitor;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

public class NotificationHandler {
    private static final int DEFAULT_NOTIFICATION_ID = 0;

    public static void displayNotification(Context context, Message message) {
        NotificationCompat.Builder builder = NotificationHandler.notificationCompatBuilder(context, message);
        if (builder == null) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            Notification notification = builder.build();
            notificationManager.notify(NotificationHandler.getNotificationId(context, message), notification);
        }
        catch (SecurityException se) {
            Log.e((String)"MobileMessaging", (String)"Unable to vibrate. Please, add the following permission to the AndroidManifest.xml: android.permission.VIBRATE");
            Log.d((String)"MobileMessaging", (String)Log.getStackTraceString((Throwable)se));
        }
    }

    private static NotificationCompat.Builder notificationCompatBuilder(Context context, Message message) {
        NotificationSettings notificationSettings = NotificationHandler.notificationSettings(context, message);
        if (notificationSettings == null) {
            return null;
        }
        Intent intent = new Intent(context, notificationSettings.getCallbackActivity());
        intent.putExtra(MobileMessagingProperty.EXTRA_MESSAGE.getKey(), message.getBundle());
        intent.addFlags(notificationSettings.getIntentFlags());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)notificationSettings.getPendingIntentFlags());
        String title = StringUtils.isNotBlank(message.getTitle()) ? message.getTitle() : notificationSettings.getDefaultTitle();
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context).setContentTitle((CharSequence)title).setContentText((CharSequence)message.getBody()).setAutoCancel(notificationSettings.isNotificationAutoCancel()).setContentIntent(pendingIntent).setWhen(message.getReceivedTimestamp().longValue());
        NotificationHandler.setNotificationSoundAndVibrate(context, notificationBuilder, message);
        NotificationHandler.setNotificationIcon(context, notificationBuilder, message);
        return notificationBuilder;
    }

    private static NotificationSettings notificationSettings(Context context, Message message) {
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance(context).getNotificationSettings();
        if (null == notificationSettings) {
            return null;
        }
        if (!notificationSettings.isDisplayNotificationEnabled() || null == notificationSettings.getCallbackActivity()) {
            return null;
        }
        if (StringUtils.isBlank(message.getBody())) {
            return null;
        }
        if (ActivityLifecycleMonitor.isForeground() && notificationSettings.isForegroundNotificationDisabled()) {
            return null;
        }
        return notificationSettings;
    }

    private static void setNotificationIcon(Context context, NotificationCompat.Builder notificationBuilder, Message message) {
        NotificationSettings notificationSettings = NotificationHandler.notificationSettings(context, message);
        if (notificationSettings == null) {
            return;
        }
        int icon = StringUtils.isNotBlank(message.getIcon()) ? ResourceLoader.loadResourceByName(context, "drawable", message.getIcon()) : notificationSettings.getDefaultIcon();
        notificationBuilder.setSmallIcon(icon);
    }

    private static void setNotificationSoundAndVibrate(Context context, NotificationCompat.Builder notificationBuilder, Message message) {
        int notificationDefaults = -1;
        if (!message.isVibrate()) {
            notificationDefaults &= 0xFFFFFFFD;
        } else if (message.isVibrate() && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.VIBRATE") == -1) {
            notificationDefaults &= 0xFFFFFFFD;
            Log.e((String)"MobileMessaging", (String)"Unable to vibrate. Please, add the following permission to the AndroidManifest.xml: android.permission.VIBRATE");
        }
        if (!message.isDefaultSound()) {
            notificationDefaults &= 0xFFFFFFFE;
        }
        notificationBuilder.setDefaults(notificationDefaults);
        String sound = message.getSound();
        if (message.isDefaultSound() || StringUtils.isBlank(sound)) {
            return;
        }
        Uri soundUri = Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + sound));
        if (soundUri == null) {
            Log.e((String)"MobileMessaging", (String)("Cannot create uri for sound:" + sound + " messageId:" + message.getMessageId()));
            return;
        }
        notificationBuilder.setSound(soundUri);
    }

    private static int getNotificationId(Context context, Message message) {
        NotificationSettings settings = NotificationHandler.notificationSettings(context, message);
        if (settings == null) {
            return 0;
        }
        boolean areMultipleNotificationsEnabled = settings.areMultipleNotificationsEnabled();
        return areMultipleNotificationsEnabled ? new Random().nextInt() : 0;
    }
}

