/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.infobip.mobile.messaging.util.ISO8601DateParseException;

public class DateTimeUtil {
    private static final String DATE_YMD_FORMAT = "yyyy-MM-dd";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String GMT_TIME_ZONE = "+00:00";
    private static final String ISO8601_GMT_Z_MATCHER = "Z$";

    public static Date ISO8601DateFromString(String dateString) throws ISO8601DateParseException {
        if (dateString == null) {
            return null;
        }
        String date = dateString.trim().replaceAll(ISO8601_GMT_Z_MATCHER, GMT_TIME_ZONE);
        try {
            return new SimpleDateFormat(DATE_FORMAT, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new ISO8601DateParseException(ISO8601DateParseException.Reason.DATE_PARSE_EXCEPTION, (Throwable)e);
        }
    }

    public static String ISO8601DateToString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.getDefault());
        return simpleDateFormat.format(date);
    }

    public static Date DateFromYMDString(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_YMD_FORMAT, Locale.getDefault()).parse(date);
    }

    public static String DateToYMDString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(DATE_YMD_FORMAT, Locale.getDefault()).format(date);
    }

    public static int compareTimes(Date d1, Date d2) {
        int t1 = (int)(d1.getTime() % 86400000L);
        int t2 = (int)(d2.getTime() % 86400000L);
        return t1 - t2;
    }

    public static int dayOfWeekISO8601() {
        Calendar calendar = Calendar.getInstance();
        int calendarDayOfWeek = calendar.get(7);
        return calendarDayOfWeek == 1 ? 7 : calendarDayOfWeek - 1;
    }

    public static boolean isCurrentTimeBetweenDates(String startTime, String endTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmm", Locale.getDefault());
        Date startDate = simpleDateFormat.parse(startTime);
        Calendar timeStart = Calendar.getInstance();
        timeStart.setTime(startDate);
        Date endDate = simpleDateFormat.parse(endTime);
        Calendar timeEnd = Calendar.getInstance();
        timeEnd.setTime(endDate);
        Date nowDate = new Date();
        return DateTimeUtil.compareTimes(startDate, nowDate) < 0 && DateTimeUtil.compareTimes(nowDate, endDate) < 0;
    }
}

