/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infobip.mobile.messaging.MobileMessagingProperty;
import org.infobip.mobile.messaging.util.Cryptor;
import org.infobip.mobile.messaging.util.DeviceInformation;
import org.infobip.mobile.messaging.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class PreferenceHelper {
    private static final Object LOCK = new Object();
    private static Cryptor cryptor = null;

    private PreferenceHelper() {
    }

    private static Cryptor getCryptor(Context context) {
        if (cryptor != null) {
            return cryptor;
        }
        cryptor = new Cryptor(DeviceInformation.getDeviceID(context));
        return cryptor;
    }

    public static String findString(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findString(context, property.getKey(), (String)property.getDefaultValue(), property.isEncrypted());
    }

    public static String findString(Context context, String key, String defaultValue) {
        return PreferenceHelper.findString(context, key, defaultValue, false);
    }

    public static String findString(Context context, String key, String defaultValue, boolean encrypted) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (!encrypted) {
            return sharedPreferences.getString(key, defaultValue);
        }
        String encryptedKey = PreferenceHelper.getCryptor(context).encrypt(key);
        String encryptedValue = sharedPreferences.getString(encryptedKey, defaultValue);
        return PreferenceHelper.getCryptor(context).decrypt(encryptedValue);
    }

    public static void saveString(Context context, MobileMessagingProperty property, String value) {
        PreferenceHelper.saveString(context, property.getKey(), value, property.isEncrypted());
    }

    public static void saveString(Context context, String key, String value, boolean encrypted) {
        if (!encrypted) {
            PreferenceHelper.saveString(context, key, value);
            return;
        }
        String encryptedKey = PreferenceHelper.getCryptor(context).encrypt(key);
        String encryptedValue = PreferenceHelper.getCryptor(context).encrypt(value);
        PreferenceHelper.saveString(context, encryptedKey, encryptedValue);
    }

    public static void saveString(Context context, String key, String value) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (null == value) {
            PreferenceHelper.remove(context, key);
            return;
        }
        sharedPreferences.edit().putString(key, value).apply();
    }

    public static long findLong(Context context, MobileMessagingProperty property) {
        Object defaultValue = property.getDefaultValue();
        if (null == defaultValue) {
            defaultValue = 0L;
        }
        return PreferenceHelper.findLong(context, property.getKey(), (Long)defaultValue);
    }

    public static long findLong(Context context, String key, long defaultValue) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String string = sharedPreferences.getString(key, String.valueOf(defaultValue));
        if (StringUtils.isBlank(string)) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public static void saveLong(Context context, MobileMessagingProperty property, long value) {
        PreferenceHelper.saveLong(context, property.getKey(), value);
    }

    public static void saveLong(Context context, String key, long value) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        sharedPreferences.edit().putString(key, String.valueOf(value)).apply();
    }

    public static <T> Class<T> findClass(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findClass(context, property.getKey(), (Class)property.getDefaultValue());
    }

    public static <T> Class<T> findClass(Context context, String key, Class<T> defaultValue) {
        String callbackActivityClassName = PreferenceHelper.findString(context, key, null);
        if (StringUtils.isBlank(callbackActivityClassName)) {
            return defaultValue;
        }
        try {
            return Class.forName(callbackActivityClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void saveClass(Context context, MobileMessagingProperty property, Class<?> aClass) {
        PreferenceHelper.saveClass(context, property.getKey(), aClass);
    }

    public static void saveClass(Context context, String key, Class<?> aClass) {
        String value = null != aClass.getName() ? aClass.getName() : null;
        PreferenceHelper.saveString(context, key, value);
    }

    public static boolean findBoolean(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findBoolean(context, property.getKey(), Boolean.TRUE.equals(property.getDefaultValue()));
    }

    public static boolean findBoolean(Context context, String key, boolean defaultValue) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return sharedPreferences.getBoolean(key, defaultValue);
    }

    public static void saveBoolean(Context context, MobileMessagingProperty property, boolean value) {
        PreferenceHelper.saveBoolean(context, property.getKey(), value);
    }

    public static void saveBoolean(Context context, String key, boolean value) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        sharedPreferences.edit().putBoolean(key, value).apply();
    }

    public static int findInt(Context context, MobileMessagingProperty property) {
        Object defaultValue = property.getDefaultValue();
        int defaultInt = 0;
        if (null != defaultValue) {
            defaultInt = (Integer)defaultValue;
        }
        return PreferenceHelper.findInt(context, property.getKey(), defaultInt);
    }

    public static int findInt(Context context, String key, int defaultValue) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return sharedPreferences.getInt(key, defaultValue);
    }

    public static void saveInt(Context context, MobileMessagingProperty property, int value) {
        PreferenceHelper.saveInt(context, property.getKey(), value);
    }

    public static void saveInt(Context context, String key, int value) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        sharedPreferences.edit().putInt(key, value).apply();
    }

    public static long[] findLongArray(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findLongArray(context, property.getKey(), (long[])property.getDefaultValue());
    }

    public static long[] findLongArray(Context context, String key, long[] defaultValue) {
        String vibrate = PreferenceHelper.findString(context, key, null);
        if (null == vibrate) {
            return defaultValue;
        }
        try {
            JSONArray jsonArray = new JSONArray(vibrate);
            long[] vibratePattern = new long[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                vibratePattern[i] = jsonArray.getLong(i);
            }
            return vibratePattern;
        }
        catch (JSONException e) {
            return defaultValue;
        }
    }

    public static void saveLongArray(Context context, MobileMessagingProperty property, long[] value) {
        PreferenceHelper.saveLongArray(context, property.getKey(), value);
    }

    public static void saveLongArray(Context context, String key, long[] value) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (null == value) {
            PreferenceHelper.remove(context, key);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (long aValue : value) {
            jsonArray.put(aValue);
        }
        sharedPreferences.edit().putString(key, jsonArray.toString()).apply();
    }

    public static String[] findStringArray(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.findStringArray(context, property.getKey(), (String[])property.getDefaultValue());
    }

    public static String[] findStringArray(Context context, String key, String[] defaultValue) {
        return PreferenceHelper.find(context, key, defaultValue, new SetConverter<String[]>(){

            @Override
            public String[] convert(Set<String> set) {
                return set.toArray(new String[set.size()]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T find(Context context, String key, T defaultValue, SetConverter<T> converter) {
        Object object = LOCK;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            Set value = sharedPreferences.getStringSet(key, null);
            if (null == value) {
                return defaultValue;
            }
            return converter.convert(value);
        }
    }

    public static void appendToStringArray(Context context, MobileMessagingProperty property, String ... strings) {
        PreferenceHelper.appendToStringArray(context, property.getKey(), strings);
    }

    public static void appendToStringArray(Context context, String key, final String ... strings) {
        SetMutator mutator = new SetMutator(){

            @Override
            public void mutate(Set<String> set) {
                set.addAll(Arrays.asList(strings));
            }
        };
        PreferenceHelper.editSet(context, key, mutator);
    }

    public static void deleteFromStringArray(Context context, MobileMessagingProperty property, String ... strings) {
        PreferenceHelper.deleteFromStringArray(context, property.getKey(), strings);
    }

    public static void deleteFromStringArray(Context context, String key, final String ... strings) {
        SetMutator mutator = new SetMutator(){

            @Override
            public void mutate(Set<String> set) {
                set.removeAll(Arrays.asList(strings));
            }
        };
        PreferenceHelper.editSet(context, key, mutator);
    }

    public static void saveStringArray(Context context, MobileMessagingProperty property, final String ... strings) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        HashSet<String> stringSet = new HashSet<String>(){
            {
                this.addAll(Arrays.asList(strings));
            }
        };
        sharedPreferences.edit().putStringSet(property.getKey(), (Set)stringSet).apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editSet(Context context, String key, SetMutator mutator) {
        Object object = LOCK;
        synchronized (object) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            HashSet<String> set = new HashSet<String>(sharedPreferences.getStringSet(key, new HashSet()));
            mutator.mutate(set);
            if (set.isEmpty()) {
                PreferenceHelper.remove(context, key);
                return;
            }
            sharedPreferences.edit().putStringSet(key, set).apply();
        }
    }

    public static void remove(Context context, MobileMessagingProperty property) {
        PreferenceHelper.remove(context, property.getKey());
    }

    public static void remove(Context context, String key) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().remove(key).apply();
    }

    public static boolean contains(Context context, MobileMessagingProperty property) {
        return PreferenceHelper.contains(context, property.getKey());
    }

    public static boolean contains(Context context, String key) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).contains(key);
    }

    public static void registerOnSharedPreferenceChangeListener(Context context, SharedPreferences.OnSharedPreferenceChangeListener listener) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).registerOnSharedPreferenceChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Result> Result runTransaction(Transaction<Result> transaction) {
        Object object = LOCK;
        synchronized (object) {
            return transaction.run();
        }
    }

    public static interface Transaction<Result> {
        public Result run();
    }

    public static interface SetConverter<T> {
        public T convert(Set<String> var1);
    }

    public static interface SetMutator {
        public void mutate(Set<String> var1);
    }
}

